<?php

/**
 * @package    com_quix
 * @author     ThemeXpert <info@themexpert.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @version    1.8.0
 */

// No direct access

use QuixNxt\Utils\Asset;
use Joomla\CMS\Factory;

defined('_JEXEC') or die;
// Load jQuery
\Joomla\CMS\HTML\HTMLHelper::_('jquery.framework');
$version = QuixAppHelper::getQuixMediaVersion();
?>
<link rel="preconnect" href="https://fonts.gstatic.com">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://ajax.googleapis.com">

<div class="qx-fb-frame">

  <div class="app-mount qx quix">
    <div id="qx-fb-mount"></div>
  </div>
</div>

<!--tinymce editor for inline editing-->
<?php

if (JFile::exists(JPATH_SITE.'/media/editors/tinymce/tinymce.min.js')) {
    Factory::getDocument()->addScript(JUri::root().'media/editors/tinymce/tinymce.min.js');
} else {
    Factory::getDocument()->addScript('https://cdnjs.cloudflare.com/ajax/libs/tinymce/5.6.2/tinymce.min.js');
}
?>

<!--core css-->
<link
        href="<?php echo Asset::getAssetUrl('/css/quix-elements.css'); ?>"
        rel="stylesheet" media="all" type="text/css" />
<!--icon-->
<link href="<?php echo Asset::getAssetUrl('/css/qxi.css'); ?>" rel="stylesheet" media="all" type="text/css" />
<link href="<?php echo \JUri::root()."media/quixnxt/css/qxicon.css?".$version; ?>" rel="stylesheet" media="all" type="text/css" />

<link
        href="<?php echo Asset::getAssetUrl('/css/quix-core.css'); ?>"
        rel="stylesheet" media="all" type="text/css" />
<!--core builder only-->
<link
        href="<?php echo Asset::getAssetUrl('/css/quix-builder.css'); ?>"
        rel="stylesheet" media="all" type="text/css" />
<!--iframe inside assets fix-->
<script>
  var quix = <?php echo json_encode(['url' => QUIXNXT_SITE_URL, 'version' => QUIXNXT_VERSION]) ?>;
</script>
<script src="<?php echo Asset::getAssetUrl('/js/iframe.js'); ?>" type="text/javascript"></script>
<script src="<?php echo Asset::getAssetUrl('/js/quix.js'); ?>" type="text/javascript"></script>
<script src="<?php echo Asset::getAssetUrl('/js/qxkit.js'); ?>" type="text/javascript"></script>
<script src="https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js" type="text/javascript" defer></script>

<script>
    var interval = setInterval(function() {window.parent.postMessage({event: 'iframe-loaded'}, window.origin);}, 1000);
    setTimeout(function() {clearInterval(interval);}, 1000 * 60);// stop after one minute
</script>
<script>
    // resizer fix
    var resizeTimer;
    adjustSectionWidths();

    jQuery(window).resize(function() {
        clearTimeout(resizeTimer);
        resizeTimer = setTimeout(adjustSectionWidths, 200); // Adjust the debounce delay as needed
    });
    function adjustSectionWidths() {
        var direction = jQuery('html').attr('dir');
        var offset = 0;
        var extraSpace = jQuery('html').hasClass('quix-builder') ? 20 : 0;

        jQuery('.qx-section--stretch').each(function() {
            var qxSectionStretch = jQuery(this);
            qxSectionStretch.css('margin-left', 0);
            setTimeout(() => {
                qxSectionStretch.css('width', document.body.clientWidth);
                offset = parseInt(qxSectionStretch.offset().left);
                if (offset === 0) {
                    qxSectionStretch.css('offset', offset + 'px');
                }else{
                    if (direction === 'rtl') {
                        qxSectionStretch.css('margin-right', (offset  - extraSpace) + 'px');
                    } else {
                        qxSectionStretch.css('margin-left', '-' + (offset  - extraSpace) + 'px');
                    }
                }
            }, 100);
        });
    };
</script>
<style>
    @font-face {
        font-family: 'qxi';
        font-display: swap;
        src: url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxi.ttf?cdywht') format('truetype'),
        url('<?php echo Joomla\CMS\Uri\Uri::root();?>media/quixnxt/fonts/qxi.woff?cdywht') format('woff');
        font-weight: normal;
        font-style: normal;
    }
</style>
