<?php
/**
 * @package     Joomla.Administrator
 * @subpackage  com_messages
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

// Include the HTML helpers.
\Joomla\CMS\HTML\HTMLHelper::addIncludePath(JPATH_COMPONENT . '/helpers/html');
// Load toolbar
$layout     = new JLayoutFile('blocks.toolbar');
echo $layout->render(['active' => '']);
?>
<style>
    pre{
        font: 12px/1.5 sans,monospace;
        color: #666;
        -moz-tab-size: 4;
        tab-size: 4;
        overflow: auto;
        padding: 25px;
        border: 0 solid #e5e5e5;
        border-radius: 0;
        background: #f8f8f8;
        margin: 0px auto 20px;
    }
</style>
<div class="quix qx-container">

    <?php echo QuixHelper::randerSysMessage(); ?>

    <div id="quix-codes-wrapper" class="qx-card qx-card-default">
        <div class="qx-card-header">
            <h3 class="qx-card-title"><?php echo \Joomla\CMS\Language\Text::_('COM_QUIX_CODES_DESC'); ?></h3>
            <p><?php echo \Joomla\CMS\Language\Text::_('COM_QUIX_CODES_PRE_TEXT'); ?></p>

            <div class="qx-alert">
                <p class="qx-text-bold qx-margin-remove-bottom"><?php echo \Joomla\CMS\Language\Text::_('COM_QUIX_CODES_WARNING_TITLE'); ?></p>
                <p class="qx-text-danger qx-margin-small-top"><?php echo \Joomla\CMS\Language\Text::_('COM_QUIX_CODES_WARNING_DESC'); ?></p>
            </div>
        </div>

        <form action="<?php echo \Joomla\CMS\Router\Route::_('index.php?option=com_quix&view=codes'); ?>" method="post"
              name="headCodeForm" id="headCode" class="form-validate form-horizontal qx-admin-box">

            <div class="qx-card-muted qx-card-body">
                <div class="qx-flex qx-flex-between">
                    <div class="qx-width-expand">
                        <h4><?php echo \Joomla\CMS\Language\Text::_('COM_QUIX_CODES_HEAD_CODE'); ?></h4>
                        <p><?php echo \Joomla\CMS\Language\Text::_('COM_QUIX_CODES_HEAD_CODE_DESC'); ?></p>
                    </div>
                    <div>
                        <button type="submit" class="qx-button"><?php echo \Joomla\CMS\Language\Text::_('COM_QUIX_CODES_SAVE_BUTTON'); ?></button>
                    </div>
                </div>
                <div class="code-editor-wrapper" style="display:none;">
                    <?php echo $this->form->getInput('head_code'); ?>
                </div>
            </div>
            <input type="hidden" name="task" value="codes.save"/>
            <input type="hidden" name="section" value="head"/>
            <input type="hidden" name="view" value="config"/>
            <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
        </form>

        <hr class="qx-divider" />

        <form action="<?php echo \Joomla\CMS\Router\Route::_('index.php?option=com_quix&view=codes'); ?>" method="post"
              name="footerCodeForm" id="footerCode" class="form-validate form-horizontal qx-admin-box">

            <div class="qx-card-muted qx-card-body">
                <div class="qx-flex qx-flex-between">
                    <div class="qx-width-expand">
                        <h4><?php echo \Joomla\CMS\Language\Text::_('COM_QUIX_CODES_FOOTER_CODE'); ?></h4>
                        <p><?php echo \Joomla\CMS\Language\Text::_('COM_QUIX_CODES_FOOTER_CODE_DESC'); ?></p>
                    </div>
                    <div>
                        <button type="submit" class="qx-button"><?php echo \Joomla\CMS\Language\Text::_('COM_QUIX_CODES_SAVE_BUTTON'); ?></button>
                    </div>
                </div>
                <div class="code-editor-wrapper" style="display:none;">
                    <?php echo $this->form->getInput('footer_code'); ?>
                </div>
            </div>
            <input type="hidden" name="task" value="codes.save"/>
            <input type="hidden" name="section" value="footer"/>
            <input type="hidden" name="view" value="config"/>
            <?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
        </form>
    </div>
</div>

<?php echo QuixHelper::getFooterLayout(); ?>

