<?php
/*
 * Copyright 2016 Google
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//
// Generated by validator_gen_php.py - do not edit.
//   validator_gen_php.py is available in a Lullabot forked repo https://github.com/Lullabot/amphtml
//   Be sure to look in the `php-validator-generated` branch of the repo in the `validator` folder
//

namespace Lullabot\AMP\Spec;

class AmpLayout {
  public $supported_layouts = [];
  public $defines_default_width = null;
  public $defines_default_height = null;
}

class AmpLayoutLayout {
 const UNKNOWN = 'UNKNOWN';
 const NODISPLAY = 'NODISPLAY';
 const FIXED = 'FIXED';
 const FIXED_HEIGHT = 'FIXED_HEIGHT';
 const RESPONSIVE = 'RESPONSIVE';
 const CONTAINER = 'CONTAINER';
 const FILL = 'FILL';
 const FLEX_ITEM = 'FLEX_ITEM';

}
class AtRuleSpec {
  public $name = null;
  public $type = null;
}

class AtRuleSpecBlockType {
 const PARSE_AS_ERROR = 'PARSE_AS_ERROR';
 const PARSE_AS_IGNORE = 'PARSE_AS_IGNORE';
 const PARSE_AS_RULES = 'PARSE_AS_RULES';
 const PARSE_AS_DECLARATIONS = 'PARSE_AS_DECLARATIONS';

}
class AttrList {
  public $name = null;
  public $attrs = [];
}

class AttrSpec {
  public $name = null;
  public $alternative_names = [];
  public $mandatory = null;
  public $mandatory_oneof = null;
  public $value = null;
  public $value_regex = null;
  public $value_regex_casei = null;
  public $value_url = null;
  public $value_properties = null;
  public $trigger = null;
  public $blacklisted_value_regex = null;
  public $deprecation = null;
  public $deprecation_url = null;
  public $dispatch_key = null;
  public $implicit = null;
}

class AttrTriggerSpec {
  public $if_value_regex = null;
  public $also_requires_attr = [];
}

class BlackListedCDataRegex {
  public $regex = null;
  public $error_message = null;
}

class CdataSpec {
  public $max_bytes = null;
  public $max_bytes_spec_url = null;
  public $mandatory_cdata = null;
  public $cdata_regex = null;
  public $css_spec = null;
  public $blacklisted_cdata_regex = [];
}

class ChildTagSpec {
  public $mandatory_num_child_tags = null;
  public $first_child_tag_name_oneof = [];
  public $child_tag_name_oneof = [];
}

class CssRuleSpec {
}

class CssSpec {
  public $at_rule_spec = [];
  public $css_rule = [];
  public $image_url_spec = null;
  public $font_url_spec = null;
}

class ErrorCategory {
}

class ErrorCategoryCode {
 const UNKNOWN = 'UNKNOWN';
 const GENERIC = 'GENERIC';
 const DISALLOWED_HTML_WITH_AMP_EQUIVALENT = 'DISALLOWED_HTML_WITH_AMP_EQUIVALENT';
 const DISALLOWED_HTML = 'DISALLOWED_HTML';
 const AUTHOR_STYLESHEET_PROBLEM = 'AUTHOR_STYLESHEET_PROBLEM';
 const MANDATORY_AMP_TAG_MISSING_OR_INCORRECT = 'MANDATORY_AMP_TAG_MISSING_OR_INCORRECT';
 const AMP_TAG_PROBLEM = 'AMP_TAG_PROBLEM';
 const CUSTOM_JAVASCRIPT_DISALLOWED = 'CUSTOM_JAVASCRIPT_DISALLOWED';
 const AMP_LAYOUT_PROBLEM = 'AMP_LAYOUT_PROBLEM';
 const AMP_HTML_TEMPLATE_PROBLEM = 'AMP_HTML_TEMPLATE_PROBLEM';
 const DEPRECATION = 'DEPRECATION';

}
class ErrorFormat {
  public $code = null;
  public $format = null;
}

class PropertySpec {
  public $name = null;
  public $mandatory = null;
  public $value = null;
  public $value_double = null;
}

class PropertySpecList {
  public $properties = [];
}

class TagSpec {
  public $tag_name = null;
  public $spec_name = null;
  public $mandatory = null;
  public $mandatory_alternatives = null;
  public $unique = null;
  public $mandatory_parent = null;
  public $mandatory_ancestor = null;
  public $mandatory_ancestor_suggested_alternative = null;
  public $disallowed_ancestor = [];
  public $also_requires_tag = [];
  public $deprecation = null;
  public $deprecation_url = null;
  public $attrs = [];
  public $attr_lists = [];
  public $cdata = null;
  public $child_tags = null;
  public $spec_url = null;
  public $amp_layout = null;
}

class UrlSpec {
  public $allowed_protocol = [];
  public $allow_relative = null;
  public $allow_empty = null;
}

class ValidationError {
  public $severity = null;
  public $code = null;
  public $line = null;
  public $col = null;
  public $detail = null;
  public $spec_url = null;
  public $params = [];
  public $category = null;
  public $data_amp_report_test_value = null;
}

class ValidationErrorCode {
 const UNKNOWN_CODE = 'UNKNOWN_CODE';
 const MANDATORY_TAG_MISSING = 'MANDATORY_TAG_MISSING';
 const TAG_REQUIRED_BY_MISSING = 'TAG_REQUIRED_BY_MISSING';
 const ATTR_REQUIRED_BUT_MISSING = 'ATTR_REQUIRED_BUT_MISSING';
 const DISALLOWED_TAG = 'DISALLOWED_TAG';
 const GENERAL_DISALLOWED_TAG = 'GENERAL_DISALLOWED_TAG';
 const DISALLOWED_ATTR = 'DISALLOWED_ATTR';
 const INVALID_ATTR_VALUE = 'INVALID_ATTR_VALUE';
 const ATTR_VALUE_REQUIRED_BY_LAYOUT = 'ATTR_VALUE_REQUIRED_BY_LAYOUT';
 const IMPLIED_LAYOUT_INVALID = 'IMPLIED_LAYOUT_INVALID';
 const SPECIFIED_LAYOUT_INVALID = 'SPECIFIED_LAYOUT_INVALID';
 const MANDATORY_ATTR_MISSING = 'MANDATORY_ATTR_MISSING';
 const MANDATORY_ONEOF_ATTR_MISSING = 'MANDATORY_ONEOF_ATTR_MISSING';
 const DUPLICATE_DIMENSION = 'DUPLICATE_DIMENSION';
 const DUPLICATE_UNIQUE_TAG = 'DUPLICATE_UNIQUE_TAG';
 const WRONG_PARENT_TAG = 'WRONG_PARENT_TAG';
 const STYLESHEET_TOO_LONG_OLD_VARIANT = 'STYLESHEET_TOO_LONG_OLD_VARIANT';
 const STYLESHEET_TOO_LONG = 'STYLESHEET_TOO_LONG';
 const MANDATORY_CDATA_MISSING_OR_INCORRECT = 'MANDATORY_CDATA_MISSING_OR_INCORRECT';
 const CDATA_VIOLATES_BLACKLIST = 'CDATA_VIOLATES_BLACKLIST';
 const DEV_MODE_ENABLED = 'DEV_MODE_ENABLED';
 const DEPRECATED_ATTR = 'DEPRECATED_ATTR';
 const DEPRECATED_TAG = 'DEPRECATED_TAG';
 const MANDATORY_PROPERTY_MISSING_FROM_ATTR_VALUE = 'MANDATORY_PROPERTY_MISSING_FROM_ATTR_VALUE';
 const INVALID_PROPERTY_VALUE_IN_ATTR_VALUE = 'INVALID_PROPERTY_VALUE_IN_ATTR_VALUE';
 const MISSING_URL = 'MISSING_URL';
 const INVALID_URL = 'INVALID_URL';
 const INVALID_URL_PROTOCOL = 'INVALID_URL_PROTOCOL';
 const DISALLOWED_RELATIVE_URL = 'DISALLOWED_RELATIVE_URL';
 const DISALLOWED_PROPERTY_IN_ATTR_VALUE = 'DISALLOWED_PROPERTY_IN_ATTR_VALUE';
 const MUTUALLY_EXCLUSIVE_ATTRS = 'MUTUALLY_EXCLUSIVE_ATTRS';
 const UNESCAPED_TEMPLATE_IN_ATTR_VALUE = 'UNESCAPED_TEMPLATE_IN_ATTR_VALUE';
 const TEMPLATE_PARTIAL_IN_ATTR_VALUE = 'TEMPLATE_PARTIAL_IN_ATTR_VALUE';
 const TEMPLATE_IN_ATTR_NAME = 'TEMPLATE_IN_ATTR_NAME';
 const INCONSISTENT_UNITS_FOR_WIDTH_AND_HEIGHT = 'INCONSISTENT_UNITS_FOR_WIDTH_AND_HEIGHT';
 const DISALLOWED_TAG_ANCESTOR = 'DISALLOWED_TAG_ANCESTOR';
 const MANDATORY_TAG_ANCESTOR = 'MANDATORY_TAG_ANCESTOR';
 const MANDATORY_TAG_ANCESTOR_WITH_HINT = 'MANDATORY_TAG_ANCESTOR_WITH_HINT';
 const ATTR_DISALLOWED_BY_IMPLIED_LAYOUT = 'ATTR_DISALLOWED_BY_IMPLIED_LAYOUT';
 const ATTR_DISALLOWED_BY_SPECIFIED_LAYOUT = 'ATTR_DISALLOWED_BY_SPECIFIED_LAYOUT';
 const INCORRECT_NUM_CHILD_TAGS = 'INCORRECT_NUM_CHILD_TAGS';
 const DISALLOWED_CHILD_TAG_NAME = 'DISALLOWED_CHILD_TAG_NAME';
 const DISALLOWED_FIRST_CHILD_TAG_NAME = 'DISALLOWED_FIRST_CHILD_TAG_NAME';
 const CSS_SYNTAX = 'CSS_SYNTAX';
 const CSS_SYNTAX_INVALID_AT_RULE = 'CSS_SYNTAX_INVALID_AT_RULE';
 const CSS_SYNTAX_STRAY_TRAILING_BACKSLASH = 'CSS_SYNTAX_STRAY_TRAILING_BACKSLASH';
 const CSS_SYNTAX_UNTERMINATED_COMMENT = 'CSS_SYNTAX_UNTERMINATED_COMMENT';
 const CSS_SYNTAX_UNTERMINATED_STRING = 'CSS_SYNTAX_UNTERMINATED_STRING';
 const CSS_SYNTAX_BAD_URL = 'CSS_SYNTAX_BAD_URL';
 const CSS_SYNTAX_EOF_IN_PRELUDE_OF_QUALIFIED_RULE = 'CSS_SYNTAX_EOF_IN_PRELUDE_OF_QUALIFIED_RULE';
 const CSS_SYNTAX_INVALID_DECLARATION = 'CSS_SYNTAX_INVALID_DECLARATION';
 const CSS_SYNTAX_INCOMPLETE_DECLARATION = 'CSS_SYNTAX_INCOMPLETE_DECLARATION';
 const CSS_SYNTAX_ERROR_IN_PSEUDO_SELECTOR = 'CSS_SYNTAX_ERROR_IN_PSEUDO_SELECTOR';
 const CSS_SYNTAX_MISSING_SELECTOR = 'CSS_SYNTAX_MISSING_SELECTOR';
 const CSS_SYNTAX_NOT_A_SELECTOR_START = 'CSS_SYNTAX_NOT_A_SELECTOR_START';
 const CSS_SYNTAX_UNPARSED_INPUT_REMAINS_IN_SELECTOR = 'CSS_SYNTAX_UNPARSED_INPUT_REMAINS_IN_SELECTOR';
 const CSS_SYNTAX_MISSING_URL = 'CSS_SYNTAX_MISSING_URL';
 const CSS_SYNTAX_INVALID_URL = 'CSS_SYNTAX_INVALID_URL';
 const CSS_SYNTAX_INVALID_URL_PROTOCOL = 'CSS_SYNTAX_INVALID_URL_PROTOCOL';
 const CSS_SYNTAX_DISALLOWED_RELATIVE_URL = 'CSS_SYNTAX_DISALLOWED_RELATIVE_URL';
 const CSS_SYNTAX_INVALID_ATTR_SELECTOR = 'CSS_SYNTAX_INVALID_ATTR_SELECTOR';

}
class ValidationErrorSeverity {
 const UNKNOWN_SEVERITY = 'UNKNOWN_SEVERITY';
 const ERROR = 'ERROR';
 const WARNING = 'WARNING';
 const PROD_WARNING = 'PROD_WARNING';
 const DEV_WARNING = 'DEV_WARNING';

}
class ValidationResult {
  public $status = null;
  public $errors = [];
  public $validator_revision = null;
  public $spec_file_revision = null;
}

class ValidationResultStatus {
 const UNKNOWN = 'UNKNOWN';
 const PASS = 'PASS';
 const FAIL = 'FAIL';

}
class ValidatorInfo {
  public $rules_path = null;
  public $validator_revision = null;
  public $spec_file_revision = null;
}

class ValidatorRules {
  public $tags = [];
  public $attr_lists = [];
  public $min_validator_revision_required = null;
  public $spec_file_revision = null;
  public $template_spec_url = null;
  public $error_formats = [];
}

class ValidationRulesFactory {
  public static function createValidationRules() {
  $o_0 = new ValidatorRules();
  $o_1 = new TagSpec();
  $o_1->tag_name = '!doctype';
  $o_1->spec_name = 'html doctype';
  $o_1->mandatory = true;
  $o_1->unique = true;
  $o_1->mandatory_parent = '$ROOT';
  $o_2 = new AttrSpec();
  $o_2->name = 'html';
  $o_2->mandatory = true;
  $o_2->value = '';
  $o_1->attrs[] = $o_2;
  $o_0->tags[] = $o_1;
  $o_3 = new TagSpec();
  $o_3->tag_name = 'html';
  $o_3->spec_name = 'html \u26a1 for top-level html';
  $o_3->mandatory = true;
  $o_3->unique = true;
  $o_3->mandatory_parent = '!doctype';
  $o_4 = new AttrSpec();
  $o_4->name = '\u26a1';
  $o_4->alternative_names = ['amp'];
  $o_4->mandatory = true;
  $o_4->value = '';
  $o_3->attrs[] = $o_4;
  $o_3->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#required-markup';
  $o_0->tags[] = $o_3;
  $o_5 = new TagSpec();
  $o_5->tag_name = 'head';
  $o_5->mandatory = true;
  $o_5->unique = true;
  $o_5->mandatory_parent = 'html';
  $o_5->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#required-markup';
  $o_0->tags[] = $o_5;
  $o_6 = new TagSpec();
  $o_6->tag_name = 'title';
  $o_6->spec_name = 'title';
  $o_0->tags[] = $o_6;
  $o_7 = new TagSpec();
  $o_7->tag_name = 'base';
  $o_8 = new AttrSpec();
  $o_8->name = 'target';
  $o_8->value_regex_casei = '(_blank|_self)';
  $o_7->attrs[] = $o_8;
  $o_0->tags[] = $o_7;
  $o_9 = new TagSpec();
  $o_9->tag_name = 'link';
  $o_9->spec_name = 'link rel=';
  $o_10 = new AttrSpec();
  $o_10->name = 'href';
  $o_9->attrs[] = $o_10;
  $o_11 = new AttrSpec();
  $o_11->name = 'rel';
  $o_11->mandatory = true;
  $o_11->blacklisted_value_regex = '(^|\\s)(canonical|components|dns-prefetch|import|manifest|preconnect|prefetch|preload|prerender|serviceworker|stylesheet|subresource|)(\\s|$)';
  $o_9->attrs[] = $o_11;
  $o_12 = new AttrSpec();
  $o_12->name = 'sizes';
  $o_9->attrs[] = $o_12;
  $o_13 = new AttrSpec();
  $o_13->name = 'type';
  $o_9->attrs[] = $o_13;
  $o_9->attr_lists = ['common-link-attrs'];
  $o_9->disallowed_ancestor = ['template'];
  $o_0->tags[] = $o_9;
  $o_14 = new TagSpec();
  $o_14->tag_name = 'link';
  $o_14->spec_name = 'link rel=canonical';
  $o_14->mandatory = true;
  $o_14->unique = true;
  $o_14->mandatory_parent = 'head';
  $o_15 = new AttrSpec();
  $o_15->name = 'href';
  $o_15->mandatory = true;
  $o_16 = new UrlSpec();
  $o_16->allowed_protocol = ['http', 'https'];
  $o_16->allow_relative = true;
  $o_15->value_url = $o_16;
  $o_14->attrs[] = $o_15;
  $o_17 = new AttrSpec();
  $o_17->name = 'rel';
  $o_17->mandatory = true;
  $o_17->value = 'canonical';
  $o_17->dispatch_key = true;
  $o_14->attrs[] = $o_17;
  $o_14->attr_lists = ['common-link-attrs'];
  $o_14->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#required-markup';
  $o_0->tags[] = $o_14;
  $o_18 = new TagSpec();
  $o_18->tag_name = 'link';
  $o_18->spec_name = 'link rel=stylesheet for fonts';
  $o_18->mandatory_parent = 'head';
  $o_19 = new AttrSpec();
  $o_19->name = 'href';
  $o_19->mandatory = true;
  $o_19->value_regex = 'https://fonts\\.googleapis\\.com/css\\?.*|https://fonts\\.googleapis\\.com/icon\\?.*|https://fonts\\.googleapis\\.com/earlyaccess/.*\\.css|https://fast\\.fonts\\.net/.*|https://maxcdn\\.bootstrapcdn\\.com/font-awesome/.*';
  $o_18->attrs[] = $o_19;
  $o_20 = new AttrSpec();
  $o_20->name = 'rel';
  $o_20->mandatory = true;
  $o_20->value = 'stylesheet';
  $o_20->dispatch_key = true;
  $o_18->attrs[] = $o_20;
  $o_21 = new AttrSpec();
  $o_21->name = 'type';
  $o_21->value = 'text/css';
  $o_18->attrs[] = $o_21;
  $o_22 = new AttrSpec();
  $o_22->name = 'media';
  $o_18->attrs[] = $o_22;
  $o_0->tags[] = $o_18;
  $o_23 = new TagSpec();
  $o_23->tag_name = 'link';
  $o_23->spec_name = 'link itemprop=sameAs';
  $o_24 = new AttrSpec();
  $o_24->name = 'href';
  $o_24->mandatory = true;
  $o_23->attrs[] = $o_24;
  $o_25 = new AttrSpec();
  $o_25->name = 'itemprop';
  $o_25->mandatory = true;
  $o_25->value = 'sameAs';
  $o_25->dispatch_key = true;
  $o_23->attrs[] = $o_25;
  $o_23->attr_lists = ['common-link-attrs'];
  $o_0->tags[] = $o_23;
  $o_26 = new TagSpec();
  $o_26->tag_name = 'link';
  $o_26->spec_name = 'link itemprop=';
  $o_27 = new AttrSpec();
  $o_27->name = 'href';
  $o_27->mandatory = true;
  $o_26->attrs[] = $o_27;
  $o_28 = new AttrSpec();
  $o_28->name = 'itemprop';
  $o_28->mandatory = true;
  $o_26->attrs[] = $o_28;
  $o_26->attr_lists = ['common-link-attrs'];
  $o_0->tags[] = $o_26;
  $o_29 = new TagSpec();
  $o_29->tag_name = 'meta';
  $o_29->spec_name = 'meta charset=utf-8';
  $o_29->mandatory = true;
  $o_29->unique = true;
  $o_29->mandatory_parent = 'head';
  $o_30 = new AttrSpec();
  $o_30->name = 'charset';
  $o_30->mandatory = true;
  $o_30->value = 'utf-8';
  $o_30->dispatch_key = true;
  $o_29->attrs[] = $o_30;
  $o_29->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#required-markup';
  $o_0->tags[] = $o_29;
  $o_31 = new TagSpec();
  $o_31->tag_name = 'meta';
  $o_31->spec_name = 'meta name=viewport';
  $o_31->mandatory = true;
  $o_31->unique = true;
  $o_31->mandatory_parent = 'head';
  $o_32 = new AttrSpec();
  $o_32->name = 'content';
  $o_32->mandatory = true;
  $o_33 = new PropertySpecList();
  $o_34 = new PropertySpec();
  $o_34->name = 'width';
  $o_34->mandatory = true;
  $o_34->value = 'device-width';
  $o_33->properties[] = $o_34;
  $o_35 = new PropertySpec();
  $o_35->name = 'height';
  $o_33->properties[] = $o_35;
  $o_36 = new PropertySpec();
  $o_36->name = 'initial-scale';
  $o_33->properties[] = $o_36;
  $o_37 = new PropertySpec();
  $o_37->name = 'minimum-scale';
  $o_37->mandatory = true;
  $o_37->value_double = 1.0;
  $o_33->properties[] = $o_37;
  $o_38 = new PropertySpec();
  $o_38->name = 'maximum-scale';
  $o_33->properties[] = $o_38;
  $o_39 = new PropertySpec();
  $o_39->name = 'shrink-to-fit';
  $o_33->properties[] = $o_39;
  $o_40 = new PropertySpec();
  $o_40->name = 'user-scalable';
  $o_33->properties[] = $o_40;
  $o_32->value_properties = $o_33;
  $o_31->attrs[] = $o_32;
  $o_41 = new AttrSpec();
  $o_41->name = 'name';
  $o_41->mandatory = true;
  $o_41->value = 'viewport';
  $o_41->dispatch_key = true;
  $o_31->attrs[] = $o_41;
  $o_31->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#required-markup';
  $o_0->tags[] = $o_31;
  $o_42 = new TagSpec();
  $o_42->tag_name = 'meta';
  $o_42->spec_name = 'meta http-equiv=X-UA-Compatible';
  $o_43 = new AttrSpec();
  $o_43->name = 'http-equiv';
  $o_43->mandatory = true;
  $o_43->value = 'X-UA-Compatible';
  $o_43->dispatch_key = true;
  $o_42->attrs[] = $o_43;
  $o_44 = new AttrSpec();
  $o_44->name = 'content';
  $o_44->mandatory = true;
  $o_45 = new PropertySpecList();
  $o_46 = new PropertySpec();
  $o_46->name = 'ie';
  $o_46->value = 'edge';
  $o_45->properties[] = $o_46;
  $o_47 = new PropertySpec();
  $o_47->name = 'chrome';
  $o_47->value = '1';
  $o_45->properties[] = $o_47;
  $o_44->value_properties = $o_45;
  $o_42->attrs[] = $o_44;
  $o_0->tags[] = $o_42;
  $o_48 = new TagSpec();
  $o_48->tag_name = 'meta';
  $o_48->spec_name = 'meta name= and content=';
  $o_49 = new AttrSpec();
  $o_49->name = 'name';
  $o_49->blacklisted_value_regex = '(^|\\s)(viewport|content-disposition|revisit-after)(\\s|$)';
  $o_48->attrs[] = $o_49;
  $o_50 = new AttrSpec();
  $o_50->name = 'content';
  $o_48->attrs[] = $o_50;
  $o_51 = new AttrSpec();
  $o_51->name = 'property';
  $o_48->attrs[] = $o_51;
  $o_52 = new AttrSpec();
  $o_52->name = 'itemprop';
  $o_48->attrs[] = $o_52;
  $o_0->tags[] = $o_48;
  $o_53 = new TagSpec();
  $o_53->tag_name = 'meta';
  $o_53->spec_name = 'meta http-equiv=content-type';
  $o_54 = new AttrSpec();
  $o_54->name = 'http-equiv';
  $o_54->mandatory = true;
  $o_54->value = 'content-type';
  $o_54->dispatch_key = true;
  $o_53->attrs[] = $o_54;
  $o_55 = new AttrSpec();
  $o_55->name = 'content';
  $o_55->mandatory = true;
  $o_55->value = 'text/html; charset=utf-8';
  $o_53->attrs[] = $o_55;
  $o_0->tags[] = $o_53;
  $o_56 = new TagSpec();
  $o_56->tag_name = 'meta';
  $o_56->spec_name = 'meta http-equiv=Content-Type';
  $o_57 = new AttrSpec();
  $o_57->name = 'http-equiv';
  $o_57->mandatory = true;
  $o_57->value = 'Content-Type';
  $o_57->dispatch_key = true;
  $o_56->attrs[] = $o_57;
  $o_58 = new AttrSpec();
  $o_58->name = 'content';
  $o_58->mandatory = true;
  $o_58->value = 'text/html; charset=utf-8';
  $o_56->attrs[] = $o_58;
  $o_0->tags[] = $o_56;
  $o_59 = new TagSpec();
  $o_59->tag_name = 'meta';
  $o_59->spec_name = 'meta http-equiv=content-language';
  $o_60 = new AttrSpec();
  $o_60->name = 'http-equiv';
  $o_60->mandatory = true;
  $o_60->value = 'content-language';
  $o_60->dispatch_key = true;
  $o_59->attrs[] = $o_60;
  $o_61 = new AttrSpec();
  $o_61->name = 'content';
  $o_61->mandatory = true;
  $o_59->attrs[] = $o_61;
  $o_0->tags[] = $o_59;
  $o_62 = new TagSpec();
  $o_62->tag_name = 'meta';
  $o_62->spec_name = 'meta http-equiv=pics-label';
  $o_63 = new AttrSpec();
  $o_63->name = 'http-equiv';
  $o_63->mandatory = true;
  $o_63->value = 'pics-label';
  $o_63->dispatch_key = true;
  $o_62->attrs[] = $o_63;
  $o_64 = new AttrSpec();
  $o_64->name = 'content';
  $o_64->mandatory = true;
  $o_62->attrs[] = $o_64;
  $o_0->tags[] = $o_62;
  $o_65 = new TagSpec();
  $o_65->tag_name = 'meta';
  $o_65->spec_name = 'meta http-equiv=imagetoolbar';
  $o_66 = new AttrSpec();
  $o_66->name = 'http-equiv';
  $o_66->mandatory = true;
  $o_66->value = 'imagetoolbar';
  $o_66->dispatch_key = true;
  $o_65->attrs[] = $o_66;
  $o_67 = new AttrSpec();
  $o_67->name = 'content';
  $o_67->mandatory = true;
  $o_65->attrs[] = $o_67;
  $o_0->tags[] = $o_65;
  $o_68 = new TagSpec();
  $o_68->tag_name = 'meta';
  $o_68->spec_name = 'meta http-equiv=Content-Style-Type';
  $o_69 = new AttrSpec();
  $o_69->name = 'http-equiv';
  $o_69->mandatory = true;
  $o_69->value = 'Content-Style-Type';
  $o_69->dispatch_key = true;
  $o_68->attrs[] = $o_69;
  $o_70 = new AttrSpec();
  $o_70->name = 'content';
  $o_70->mandatory = true;
  $o_70->value = 'text/css';
  $o_68->attrs[] = $o_70;
  $o_0->tags[] = $o_68;
  $o_71 = new TagSpec();
  $o_71->tag_name = 'meta';
  $o_71->spec_name = 'meta http-equiv=Content-Script-Type';
  $o_72 = new AttrSpec();
  $o_72->name = 'http-equiv';
  $o_72->mandatory = true;
  $o_72->value = 'Content-Script-Type';
  $o_72->dispatch_key = true;
  $o_71->attrs[] = $o_72;
  $o_73 = new AttrSpec();
  $o_73->name = 'content';
  $o_73->mandatory = true;
  $o_73->value = 'text/javascript';
  $o_71->attrs[] = $o_73;
  $o_0->tags[] = $o_71;
  $o_74 = new TagSpec();
  $o_74->tag_name = 'meta';
  $o_74->spec_name = 'meta http-equiv=resource-type';
  $o_75 = new AttrSpec();
  $o_75->name = 'http-equiv';
  $o_75->mandatory = true;
  $o_75->value = 'RESOURCE-TYPE';
  $o_75->dispatch_key = true;
  $o_74->attrs[] = $o_75;
  $o_76 = new AttrSpec();
  $o_76->name = 'content';
  $o_76->mandatory = true;
  $o_74->attrs[] = $o_76;
  $o_0->tags[] = $o_74;
  $o_77 = new TagSpec();
  $o_77->tag_name = 'style';
  $o_77->spec_name = 'style amp-custom';
  $o_77->unique = true;
  $o_77->mandatory_parent = 'head';
  $o_78 = new AttrSpec();
  $o_78->name = 'amp-custom';
  $o_78->mandatory = true;
  $o_78->value = '';
  $o_77->attrs[] = $o_78;
  $o_79 = new AttrSpec();
  $o_79->name = 'type';
  $o_79->value = 'text/css';
  $o_77->attrs[] = $o_79;
  $o_77->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#stylesheets';
  $o_80 = new CdataSpec();
  $o_80->max_bytes = 50000;
  $o_80->max_bytes_spec_url = 'https://www.ampproject.org/docs/reference/spec.html#maximum-size';
  $o_81 = new BlackListedCDataRegex();
  $o_81->regex = '<!--';
  $o_81->error_message = 'html comments';
  $o_80->blacklisted_cdata_regex[] = $o_81;
  $o_82 = new BlackListedCDataRegex();
  $o_82->regex = '\\.i?-amp-';
  $o_82->error_message = 'CSS -amp- class name prefix';
  $o_80->blacklisted_cdata_regex[] = $o_82;
  $o_83 = new BlackListedCDataRegex();
  $o_83->regex = '!important';
  $o_83->error_message = 'CSS !important';
  $o_80->blacklisted_cdata_regex[] = $o_83;
  $o_84 = new CssSpec();
  $o_85 = new AtRuleSpec();
  $o_85->name = 'font-face';
  $o_85->type = AtRuleSpecBlockType::PARSE_AS_DECLARATIONS;
  $o_84->at_rule_spec[] = $o_85;
  $o_86 = new AtRuleSpec();
  $o_86->name = 'keyframes';
  $o_86->type = AtRuleSpecBlockType::PARSE_AS_RULES;
  $o_84->at_rule_spec[] = $o_86;
  $o_87 = new AtRuleSpec();
  $o_87->name = 'media';
  $o_87->type = AtRuleSpecBlockType::PARSE_AS_RULES;
  $o_84->at_rule_spec[] = $o_87;
  $o_88 = new AtRuleSpec();
  $o_88->name = 'supports';
  $o_88->type = AtRuleSpecBlockType::PARSE_AS_RULES;
  $o_84->at_rule_spec[] = $o_88;
  $o_89 = new AtRuleSpec();
  $o_89->name = '-moz-keyframes';
  $o_89->type = AtRuleSpecBlockType::PARSE_AS_RULES;
  $o_84->at_rule_spec[] = $o_89;
  $o_90 = new AtRuleSpec();
  $o_90->name = '-o-keyframes';
  $o_90->type = AtRuleSpecBlockType::PARSE_AS_RULES;
  $o_84->at_rule_spec[] = $o_90;
  $o_91 = new AtRuleSpec();
  $o_91->name = '-webkit-keyframes';
  $o_91->type = AtRuleSpecBlockType::PARSE_AS_RULES;
  $o_84->at_rule_spec[] = $o_91;
  $o_92 = new AtRuleSpec();
  $o_92->name = '$DEFAULT';
  $o_92->type = AtRuleSpecBlockType::PARSE_AS_ERROR;
  $o_84->at_rule_spec[] = $o_92;
  $o_93 = new UrlSpec();
  $o_93->allowed_protocol = ['https', 'http', 'data', 'absolute'];
  $o_93->allow_relative = true;
  $o_93->allow_empty = true;
  $o_84->image_url_spec = $o_93;
  $o_94 = new UrlSpec();
  $o_94->allowed_protocol = ['https', 'http', 'data'];
  $o_94->allow_relative = true;
  $o_94->allow_empty = true;
  $o_84->font_url_spec = $o_94;
  $o_80->css_spec = $o_84;
  $o_77->cdata = $o_80;
  $o_0->tags[] = $o_77;
  $o_95 = new TagSpec();
  $o_95->tag_name = 'style';
  $o_95->spec_name = 'head > style[amp-boilerplate] - old variant';
  $o_95->mandatory_alternatives = 'head > style[amp-boilerplate]';
  $o_95->unique = true;
  $o_95->mandatory_parent = 'head';
  $o_95->spec_url = 'https://github.com/ampproject/amphtml/blob/master/spec/amp-boilerplate.md';
  $o_96 = new CdataSpec();
  $o_96->cdata_regex = 'body ?{opacity: ?0}';
  $o_95->cdata = $o_96;
  $o_95->deprecation = 'head > style[amp-boilerplate]';
  $o_95->deprecation_url = 'https://github.com/ampproject/amphtml/blob/master/spec/amp-boilerplate.md';
  $o_0->tags[] = $o_95;
  $o_97 = new TagSpec();
  $o_97->tag_name = 'style';
  $o_97->spec_name = 'noscript > style[amp-boilerplate] - old variant';
  $o_97->mandatory_alternatives = 'noscript > style[amp-boilerplate]';
  $o_97->unique = true;
  $o_97->mandatory_parent = 'noscript';
  $o_97->spec_url = 'https://github.com/ampproject/amphtml/blob/master/spec/amp-boilerplate.md';
  $o_98 = new CdataSpec();
  $o_98->cdata_regex = 'body ?{opacity: ?1}';
  $o_97->cdata = $o_98;
  $o_97->deprecation = 'noscript > style[amp-boilerplate]';
  $o_97->deprecation_url = 'https://github.com/ampproject/amphtml/blob/master/spec/amp-boilerplate.md';
  $o_0->tags[] = $o_97;
  $o_99 = new TagSpec();
  $o_99->tag_name = 'style';
  $o_99->spec_name = 'head > style[amp-boilerplate]';
  $o_99->mandatory_alternatives = 'head > style[amp-boilerplate]';
  $o_99->unique = true;
  $o_99->mandatory_parent = 'head';
  $o_100 = new AttrSpec();
  $o_100->name = 'amp-boilerplate';
  $o_100->mandatory = true;
  $o_100->value = '';
  $o_100->dispatch_key = true;
  $o_99->attrs[] = $o_100;
  $o_99->spec_url = 'https://github.com/ampproject/amphtml/blob/master/spec/amp-boilerplate.md';
  $o_101 = new CdataSpec();
  $o_101->cdata_regex = '\\s*body{-webkit-animation:-amp-start\\s+8s\\s+steps\\(1,end\\)\\s+0s\\s+1\\s+normal\\s+both;-moz-animation:-amp-start\\s+8s\\s+steps\\(1,end\\)\\s+0s\\s+1\\s+normal\\s+both;-ms-animation:-amp-start\\s+8s\\s+steps\\(1,end\\)\\s+0s\\s+1\\s+normal\\s+both;animation:-amp-start\\s+8s\\s+steps\\(1,end\\)\\s+0s\\s+1\\s+normal\\s+both}@-webkit-keyframes\\s+-amp-start{from{visibility:hidden}to{visibility:visible}}@-moz-keyframes\\s+-amp-start{from{visibility:hidden}to{visibility:visible}}@-ms-keyframes\\s+-amp-start{from{visibility:hidden}to{visibility:visible}}@-o-keyframes\\s+-amp-start{from{visibility:hidden}to{visibility:visible}}@keyframes\\s+-amp-start{from{visibility:hidden}to{visibility:visible}}\\s*';
  $o_99->cdata = $o_101;
  $o_99->also_requires_tag = ['noscript > style[amp-boilerplate]'];
  $o_0->tags[] = $o_99;
  $o_102 = new TagSpec();
  $o_102->tag_name = 'style';
  $o_102->spec_name = 'noscript > style[amp-boilerplate]';
  $o_102->mandatory_alternatives = 'noscript > style[amp-boilerplate]';
  $o_102->unique = true;
  $o_102->mandatory_parent = 'noscript';
  $o_103 = new AttrSpec();
  $o_103->name = 'amp-boilerplate';
  $o_103->mandatory = true;
  $o_103->value = '';
  $o_103->dispatch_key = true;
  $o_102->attrs[] = $o_103;
  $o_102->spec_url = 'https://github.com/ampproject/amphtml/blob/master/spec/amp-boilerplate.md';
  $o_104 = new CdataSpec();
  $o_104->cdata_regex = '\\s*body{-webkit-animation:none;-moz-animation:none;-ms-animation:none;animation:none}\\s*';
  $o_102->cdata = $o_104;
  $o_102->also_requires_tag = ['head > style[amp-boilerplate]'];
  $o_0->tags[] = $o_102;
  $o_105 = new TagSpec();
  $o_105->tag_name = 'body';
  $o_105->mandatory = true;
  $o_105->unique = true;
  $o_105->mandatory_parent = 'html';
  $o_105->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#required-markup';
  $o_0->tags[] = $o_105;
  $o_106 = new TagSpec();
  $o_106->tag_name = 'article';
  $o_0->tags[] = $o_106;
  $o_107 = new TagSpec();
  $o_107->tag_name = 'section';
  $o_107->disallowed_ancestor = ['amp-accordion'];
  $o_0->tags[] = $o_107;
  $o_108 = new TagSpec();
  $o_108->tag_name = 'nav';
  $o_0->tags[] = $o_108;
  $o_109 = new TagSpec();
  $o_109->tag_name = 'aside';
  $o_0->tags[] = $o_109;
  $o_110 = new TagSpec();
  $o_110->tag_name = 'h1';
  $o_111 = new AttrSpec();
  $o_111->name = 'align';
  $o_110->attrs[] = $o_111;
  $o_0->tags[] = $o_110;
  $o_112 = new TagSpec();
  $o_112->tag_name = 'h2';
  $o_113 = new AttrSpec();
  $o_113->name = 'align';
  $o_112->attrs[] = $o_113;
  $o_0->tags[] = $o_112;
  $o_114 = new TagSpec();
  $o_114->tag_name = 'h3';
  $o_115 = new AttrSpec();
  $o_115->name = 'align';
  $o_114->attrs[] = $o_115;
  $o_0->tags[] = $o_114;
  $o_116 = new TagSpec();
  $o_116->tag_name = 'h4';
  $o_117 = new AttrSpec();
  $o_117->name = 'align';
  $o_116->attrs[] = $o_117;
  $o_0->tags[] = $o_116;
  $o_118 = new TagSpec();
  $o_118->tag_name = 'h5';
  $o_119 = new AttrSpec();
  $o_119->name = 'align';
  $o_118->attrs[] = $o_119;
  $o_0->tags[] = $o_118;
  $o_120 = new TagSpec();
  $o_120->tag_name = 'h6';
  $o_121 = new AttrSpec();
  $o_121->name = 'align';
  $o_120->attrs[] = $o_121;
  $o_0->tags[] = $o_120;
  $o_122 = new TagSpec();
  $o_122->tag_name = 'header';
  $o_0->tags[] = $o_122;
  $o_123 = new TagSpec();
  $o_123->tag_name = 'footer';
  $o_0->tags[] = $o_123;
  $o_124 = new TagSpec();
  $o_124->tag_name = 'address';
  $o_0->tags[] = $o_124;
  $o_125 = new TagSpec();
  $o_125->tag_name = 'p';
  $o_126 = new AttrSpec();
  $o_126->name = 'align';
  $o_125->attrs[] = $o_126;
  $o_0->tags[] = $o_125;
  $o_127 = new TagSpec();
  $o_127->tag_name = 'hr';
  $o_0->tags[] = $o_127;
  $o_128 = new TagSpec();
  $o_128->tag_name = 'pre';
  $o_0->tags[] = $o_128;
  $o_129 = new TagSpec();
  $o_129->tag_name = 'blockquote';
  $o_130 = new AttrSpec();
  $o_130->name = 'align';
  $o_129->attrs[] = $o_130;
  $o_129->attr_lists = ['cite-attr'];
  $o_0->tags[] = $o_129;
  $o_131 = new TagSpec();
  $o_131->tag_name = 'ol';
  $o_132 = new AttrSpec();
  $o_132->name = 'reversed';
  $o_132->value = '';
  $o_131->attrs[] = $o_132;
  $o_133 = new AttrSpec();
  $o_133->name = 'start';
  $o_133->value_regex = '[0-9]*';
  $o_131->attrs[] = $o_133;
  $o_134 = new AttrSpec();
  $o_134->name = 'type';
  $o_134->value_regex = '[1AaIi]';
  $o_131->attrs[] = $o_134;
  $o_0->tags[] = $o_131;
  $o_135 = new TagSpec();
  $o_135->tag_name = 'ul';
  $o_0->tags[] = $o_135;
  $o_136 = new TagSpec();
  $o_136->tag_name = 'li';
  $o_137 = new AttrSpec();
  $o_137->name = 'value';
  $o_137->value_regex = '[0-9]*';
  $o_136->attrs[] = $o_137;
  $o_0->tags[] = $o_136;
  $o_138 = new TagSpec();
  $o_138->tag_name = 'dl';
  $o_0->tags[] = $o_138;
  $o_139 = new TagSpec();
  $o_139->tag_name = 'dt';
  $o_0->tags[] = $o_139;
  $o_140 = new TagSpec();
  $o_140->tag_name = 'dd';
  $o_0->tags[] = $o_140;
  $o_141 = new TagSpec();
  $o_141->tag_name = 'figure';
  $o_0->tags[] = $o_141;
  $o_142 = new TagSpec();
  $o_142->tag_name = 'figcaption';
  $o_0->tags[] = $o_142;
  $o_143 = new TagSpec();
  $o_143->tag_name = 'div';
  $o_144 = new AttrSpec();
  $o_144->name = 'align';
  $o_143->attrs[] = $o_144;
  $o_0->tags[] = $o_143;
  $o_145 = new TagSpec();
  $o_145->tag_name = 'main';
  $o_0->tags[] = $o_145;
  $o_146 = new TagSpec();
  $o_146->tag_name = 'a';
  $o_147 = new AttrSpec();
  $o_147->name = 'href';
  $o_148 = new UrlSpec();
  $o_148->allowed_protocol = ['ftp', 'http', 'https', 'mailto', 'fb-messenger', 'sms', 'tel', 'viber', 'whatsapp'];
  $o_148->allow_relative = true;
  $o_147->value_url = $o_148;
  $o_146->attrs[] = $o_147;
  $o_149 = new AttrSpec();
  $o_149->name = 'hreflang';
  $o_146->attrs[] = $o_149;
  $o_150 = new AttrSpec();
  $o_150->name = 'rel';
  $o_150->blacklisted_value_regex = '(^|\\s)(canonical|components|dns-prefetch|import|manifest|preconnect|prefetch|preload|prerender|serviceworker|stylesheet|subresource|)(\\s|$)';
  $o_146->attrs[] = $o_150;
  $o_151 = new AttrSpec();
  $o_151->name = 'role';
  $o_151->implicit = true;
  $o_146->attrs[] = $o_151;
  $o_152 = new AttrSpec();
  $o_152->name = 'tabindex';
  $o_152->implicit = true;
  $o_146->attrs[] = $o_152;
  $o_153 = new AttrSpec();
  $o_153->name = 'target';
  $o_153->value_regex = '(_blank|_self)';
  $o_146->attrs[] = $o_153;
  $o_154 = new AttrSpec();
  $o_154->name = 'download';
  $o_146->attrs[] = $o_154;
  $o_155 = new AttrSpec();
  $o_155->name = 'media';
  $o_146->attrs[] = $o_155;
  $o_156 = new AttrSpec();
  $o_156->name = 'type';
  $o_156->value = 'text/html';
  $o_146->attrs[] = $o_156;
  $o_157 = new AttrSpec();
  $o_157->name = 'border';
  $o_146->attrs[] = $o_157;
  $o_158 = new AttrSpec();
  $o_158->name = 'name';
  $o_146->attrs[] = $o_158;
  $o_0->tags[] = $o_146;
  $o_159 = new TagSpec();
  $o_159->tag_name = 'em';
  $o_0->tags[] = $o_159;
  $o_160 = new TagSpec();
  $o_160->tag_name = 'strong';
  $o_0->tags[] = $o_160;
  $o_161 = new TagSpec();
  $o_161->tag_name = 'small';
  $o_0->tags[] = $o_161;
  $o_162 = new TagSpec();
  $o_162->tag_name = 's';
  $o_0->tags[] = $o_162;
  $o_163 = new TagSpec();
  $o_163->tag_name = 'cite';
  $o_0->tags[] = $o_163;
  $o_164 = new TagSpec();
  $o_164->tag_name = 'q';
  $o_164->attr_lists = ['cite-attr'];
  $o_0->tags[] = $o_164;
  $o_165 = new TagSpec();
  $o_165->tag_name = 'dfn';
  $o_0->tags[] = $o_165;
  $o_166 = new TagSpec();
  $o_166->tag_name = 'abbr';
  $o_0->tags[] = $o_166;
  $o_167 = new TagSpec();
  $o_167->tag_name = 'data';
  $o_0->tags[] = $o_167;
  $o_168 = new TagSpec();
  $o_168->tag_name = 'time';
  $o_169 = new AttrSpec();
  $o_169->name = 'datetime';
  $o_168->attrs[] = $o_169;
  $o_0->tags[] = $o_168;
  $o_170 = new TagSpec();
  $o_170->tag_name = 'code';
  $o_0->tags[] = $o_170;
  $o_171 = new TagSpec();
  $o_171->tag_name = 'var';
  $o_0->tags[] = $o_171;
  $o_172 = new TagSpec();
  $o_172->tag_name = 'samp';
  $o_0->tags[] = $o_172;
  $o_173 = new TagSpec();
  $o_173->tag_name = 'kbd';
  $o_0->tags[] = $o_173;
  $o_174 = new TagSpec();
  $o_174->tag_name = 'sub';
  $o_0->tags[] = $o_174;
  $o_175 = new TagSpec();
  $o_175->tag_name = 'sup';
  $o_0->tags[] = $o_175;
  $o_176 = new TagSpec();
  $o_176->tag_name = 'i';
  $o_0->tags[] = $o_176;
  $o_177 = new TagSpec();
  $o_177->tag_name = 'b';
  $o_0->tags[] = $o_177;
  $o_178 = new TagSpec();
  $o_178->tag_name = 'u';
  $o_0->tags[] = $o_178;
  $o_179 = new TagSpec();
  $o_179->tag_name = 'mark';
  $o_0->tags[] = $o_179;
  $o_180 = new TagSpec();
  $o_180->tag_name = 'ruby';
  $o_0->tags[] = $o_180;
  $o_181 = new TagSpec();
  $o_181->tag_name = 'rb';
  $o_0->tags[] = $o_181;
  $o_182 = new TagSpec();
  $o_182->tag_name = 'rt';
  $o_0->tags[] = $o_182;
  $o_183 = new TagSpec();
  $o_183->tag_name = 'rtc';
  $o_0->tags[] = $o_183;
  $o_184 = new TagSpec();
  $o_184->tag_name = 'rp';
  $o_0->tags[] = $o_184;
  $o_185 = new TagSpec();
  $o_185->tag_name = 'bdi';
  $o_0->tags[] = $o_185;
  $o_186 = new TagSpec();
  $o_186->tag_name = 'bdo';
  $o_187 = new AttrSpec();
  $o_187->name = 'dir';
  $o_186->attrs[] = $o_187;
  $o_0->tags[] = $o_186;
  $o_188 = new TagSpec();
  $o_188->tag_name = 'span';
  $o_0->tags[] = $o_188;
  $o_189 = new TagSpec();
  $o_189->tag_name = 'br';
  $o_0->tags[] = $o_189;
  $o_190 = new TagSpec();
  $o_190->tag_name = 'wbr';
  $o_0->tags[] = $o_190;
  $o_191 = new TagSpec();
  $o_191->tag_name = 'ins';
  $o_192 = new AttrSpec();
  $o_192->name = 'datetime';
  $o_191->attrs[] = $o_192;
  $o_191->attr_lists = ['cite-attr'];
  $o_0->tags[] = $o_191;
  $o_193 = new TagSpec();
  $o_193->tag_name = 'del';
  $o_194 = new AttrSpec();
  $o_194->name = 'datetime';
  $o_193->attrs[] = $o_194;
  $o_193->attr_lists = ['cite-attr'];
  $o_0->tags[] = $o_193;
  $o_195 = new TagSpec();
  $o_195->tag_name = 'img';
  $o_196 = new AttrSpec();
  $o_196->name = 'alt';
  $o_195->attrs[] = $o_196;
  $o_197 = new AttrSpec();
  $o_197->name = 'ismap';
  $o_195->attrs[] = $o_197;
  $o_198 = new AttrSpec();
  $o_198->name = 'longdesc';
  $o_199 = new UrlSpec();
  $o_199->allowed_protocol = ['http', 'https'];
  $o_199->allow_relative = true;
  $o_198->value_url = $o_199;
  $o_195->attrs[] = $o_198;
  $o_200 = new AttrSpec();
  $o_200->name = 'src';
  $o_200->alternative_names = ['srcset'];
  $o_200->mandatory = true;
  $o_201 = new UrlSpec();
  $o_201->allowed_protocol = ['data', 'https'];
  $o_201->allow_relative = true;
  $o_200->value_url = $o_201;
  $o_195->attrs[] = $o_200;
  $o_202 = new AttrSpec();
  $o_202->name = 'border';
  $o_195->attrs[] = $o_202;
  $o_203 = new AttrSpec();
  $o_203->name = 'height';
  $o_195->attrs[] = $o_203;
  $o_204 = new AttrSpec();
  $o_204->name = 'width';
  $o_195->attrs[] = $o_204;
  $o_195->spec_url = 'https://www.ampproject.org/docs/reference/amp-img.html';
  $o_195->mandatory_ancestor = 'noscript';
  $o_195->mandatory_ancestor_suggested_alternative = 'amp-img';
  $o_0->tags[] = $o_195;
  $o_205 = new TagSpec();
  $o_205->tag_name = 'video';
  $o_206 = new AttrSpec();
  $o_206->name = 'autoplay';
  $o_205->attrs[] = $o_206;
  $o_207 = new AttrSpec();
  $o_207->name = 'controls';
  $o_205->attrs[] = $o_207;
  $o_208 = new AttrSpec();
  $o_208->name = 'height';
  $o_205->attrs[] = $o_208;
  $o_209 = new AttrSpec();
  $o_209->name = 'loop';
  $o_205->attrs[] = $o_209;
  $o_210 = new AttrSpec();
  $o_210->name = 'muted';
  $o_205->attrs[] = $o_210;
  $o_211 = new AttrSpec();
  $o_211->name = 'poster';
  $o_205->attrs[] = $o_211;
  $o_212 = new AttrSpec();
  $o_212->name = 'preload';
  $o_205->attrs[] = $o_212;
  $o_213 = new AttrSpec();
  $o_213->name = 'src';
  $o_214 = new UrlSpec();
  $o_214->allowed_protocol = ['data', 'https'];
  $o_214->allow_relative = false;
  $o_213->value_url = $o_214;
  $o_205->attrs[] = $o_213;
  $o_215 = new AttrSpec();
  $o_215->name = 'width';
  $o_205->attrs[] = $o_215;
  $o_205->spec_url = 'https://www.ampproject.org/docs/reference/amp-video.html';
  $o_205->mandatory_ancestor = 'noscript';
  $o_205->mandatory_ancestor_suggested_alternative = 'amp-video';
  $o_0->tags[] = $o_205;
  $o_216 = new TagSpec();
  $o_216->tag_name = 'audio';
  $o_217 = new AttrSpec();
  $o_217->name = 'autoplay';
  $o_216->attrs[] = $o_217;
  $o_218 = new AttrSpec();
  $o_218->name = 'controls';
  $o_216->attrs[] = $o_218;
  $o_219 = new AttrSpec();
  $o_219->name = 'loop';
  $o_216->attrs[] = $o_219;
  $o_220 = new AttrSpec();
  $o_220->name = 'muted';
  $o_216->attrs[] = $o_220;
  $o_221 = new AttrSpec();
  $o_221->name = 'preload';
  $o_216->attrs[] = $o_221;
  $o_222 = new AttrSpec();
  $o_222->name = 'src';
  $o_223 = new UrlSpec();
  $o_223->allowed_protocol = ['data', 'https'];
  $o_223->allow_relative = false;
  $o_222->value_url = $o_223;
  $o_216->attrs[] = $o_222;
  $o_216->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-audio.html';
  $o_216->mandatory_ancestor = 'noscript';
  $o_216->mandatory_ancestor_suggested_alternative = 'amp-audio';
  $o_0->tags[] = $o_216;
  $o_224 = new TagSpec();
  $o_224->tag_name = 'source';
  $o_224->spec_name = 'amp-video > source';
  $o_224->mandatory_parent = 'amp-video';
  $o_225 = new AttrSpec();
  $o_225->name = 'src';
  $o_226 = new UrlSpec();
  $o_226->allowed_protocol = ['https'];
  $o_226->allow_relative = true;
  $o_225->value_url = $o_226;
  $o_224->attrs[] = $o_225;
  $o_227 = new AttrSpec();
  $o_227->name = 'media';
  $o_224->attrs[] = $o_227;
  $o_228 = new AttrSpec();
  $o_228->name = 'type';
  $o_224->attrs[] = $o_228;
  $o_224->spec_url = 'https://www.ampproject.org/docs/reference/amp-video.html';
  $o_0->tags[] = $o_224;
  $o_229 = new TagSpec();
  $o_229->tag_name = 'source';
  $o_229->spec_name = 'amp-audio > source';
  $o_229->mandatory_parent = 'amp-audio';
  $o_230 = new AttrSpec();
  $o_230->name = 'src';
  $o_231 = new UrlSpec();
  $o_231->allowed_protocol = ['https'];
  $o_231->allow_relative = true;
  $o_230->value_url = $o_231;
  $o_229->attrs[] = $o_230;
  $o_232 = new AttrSpec();
  $o_232->name = 'media';
  $o_229->attrs[] = $o_232;
  $o_233 = new AttrSpec();
  $o_233->name = 'type';
  $o_229->attrs[] = $o_233;
  $o_229->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-audio.html';
  $o_0->tags[] = $o_229;
  $o_234 = new TagSpec();
  $o_234->tag_name = 'source';
  $o_234->spec_name = 'audio > source';
  $o_234->mandatory_parent = 'audio';
  $o_235 = new AttrSpec();
  $o_235->name = 'src';
  $o_235->mandatory = true;
  $o_236 = new UrlSpec();
  $o_236->allowed_protocol = ['https'];
  $o_236->allow_relative = true;
  $o_235->value_url = $o_236;
  $o_234->attrs[] = $o_235;
  $o_237 = new AttrSpec();
  $o_237->name = 'type';
  $o_237->mandatory = true;
  $o_234->attrs[] = $o_237;
  $o_238 = new AttrSpec();
  $o_238->name = 'media';
  $o_234->attrs[] = $o_238;
  $o_0->tags[] = $o_234;
  $o_239 = new TagSpec();
  $o_239->tag_name = 'source';
  $o_239->spec_name = 'video > source';
  $o_239->mandatory_parent = 'video';
  $o_240 = new AttrSpec();
  $o_240->name = 'src';
  $o_240->mandatory = true;
  $o_241 = new UrlSpec();
  $o_241->allowed_protocol = ['https'];
  $o_241->allow_relative = true;
  $o_240->value_url = $o_241;
  $o_239->attrs[] = $o_240;
  $o_242 = new AttrSpec();
  $o_242->name = 'type';
  $o_242->mandatory = true;
  $o_239->attrs[] = $o_242;
  $o_243 = new AttrSpec();
  $o_243->name = 'media';
  $o_239->attrs[] = $o_243;
  $o_0->tags[] = $o_239;
  $o_244 = new TagSpec();
  $o_244->tag_name = 'track';
  $o_244->spec_name = 'audio > track';
  $o_244->mandatory_parent = 'audio';
  $o_244->attr_lists = ['track-attrs-no-subtitles'];
  $o_0->tags[] = $o_244;
  $o_245 = new TagSpec();
  $o_245->tag_name = 'track';
  $o_245->spec_name = 'audio > track[kind=subtitles]';
  $o_245->mandatory_parent = 'audio';
  $o_245->attr_lists = ['track-attrs-subtitles'];
  $o_0->tags[] = $o_245;
  $o_246 = new TagSpec();
  $o_246->tag_name = 'track';
  $o_246->spec_name = 'video > track';
  $o_246->mandatory_parent = 'video';
  $o_246->attr_lists = ['track-attrs-no-subtitles'];
  $o_0->tags[] = $o_246;
  $o_247 = new TagSpec();
  $o_247->tag_name = 'track';
  $o_247->spec_name = 'video > track[kind=subtitles]';
  $o_247->mandatory_parent = 'video';
  $o_247->attr_lists = ['track-attrs-subtitles'];
  $o_0->tags[] = $o_247;
  $o_248 = new TagSpec();
  $o_248->tag_name = 'track';
  $o_248->spec_name = 'amp-audio > track';
  $o_248->mandatory_parent = 'amp-audio';
  $o_248->attr_lists = ['track-attrs-no-subtitles'];
  $o_0->tags[] = $o_248;
  $o_249 = new TagSpec();
  $o_249->tag_name = 'track';
  $o_249->spec_name = 'amp-audio > track[kind=subtitles]';
  $o_249->mandatory_parent = 'amp-audio';
  $o_249->attr_lists = ['track-attrs-subtitles'];
  $o_0->tags[] = $o_249;
  $o_250 = new TagSpec();
  $o_250->tag_name = 'track';
  $o_250->spec_name = 'amp-video > track';
  $o_250->mandatory_parent = 'amp-video';
  $o_250->attr_lists = ['track-attrs-no-subtitles'];
  $o_0->tags[] = $o_250;
  $o_251 = new TagSpec();
  $o_251->tag_name = 'track';
  $o_251->spec_name = 'amp-video > track[kind=subtitles]';
  $o_251->mandatory_parent = 'amp-video';
  $o_251->attr_lists = ['track-attrs-subtitles'];
  $o_0->tags[] = $o_251;
  $o_252 = new TagSpec();
  $o_252->tag_name = 'g';
  $o_253 = new AttrSpec();
  $o_253->name = 'class';
  $o_252->attrs[] = $o_253;
  $o_254 = new AttrSpec();
  $o_254->name = 'externalresourcesrequired';
  $o_252->attrs[] = $o_254;
  $o_255 = new AttrSpec();
  $o_255->name = 'transform';
  $o_252->attrs[] = $o_255;
  $o_252->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_252->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_252->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_252;
  $o_256 = new TagSpec();
  $o_256->tag_name = 'glyph';
  $o_257 = new AttrSpec();
  $o_257->name = 'arabic-form';
  $o_256->attrs[] = $o_257;
  $o_258 = new AttrSpec();
  $o_258->name = 'class';
  $o_256->attrs[] = $o_258;
  $o_259 = new AttrSpec();
  $o_259->name = 'd';
  $o_256->attrs[] = $o_259;
  $o_260 = new AttrSpec();
  $o_260->name = 'glyph-name';
  $o_256->attrs[] = $o_260;
  $o_261 = new AttrSpec();
  $o_261->name = 'horiz-adv-x';
  $o_256->attrs[] = $o_261;
  $o_262 = new AttrSpec();
  $o_262->name = 'orientation';
  $o_256->attrs[] = $o_262;
  $o_263 = new AttrSpec();
  $o_263->name = 'unicode';
  $o_256->attrs[] = $o_263;
  $o_264 = new AttrSpec();
  $o_264->name = 'vert-origin-x';
  $o_256->attrs[] = $o_264;
  $o_265 = new AttrSpec();
  $o_265->name = 'vert-origin-y';
  $o_256->attrs[] = $o_265;
  $o_266 = new AttrSpec();
  $o_266->name = 'vert-adv-y';
  $o_256->attrs[] = $o_266;
  $o_256->attr_lists = ['svg-core-attributes', 'svg-presentation-attributes'];
  $o_256->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_256->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_256;
  $o_267 = new TagSpec();
  $o_267->tag_name = 'glyphref';
  $o_268 = new AttrSpec();
  $o_268->name = 'class';
  $o_267->attrs[] = $o_268;
  $o_269 = new AttrSpec();
  $o_269->name = 'dx';
  $o_267->attrs[] = $o_269;
  $o_270 = new AttrSpec();
  $o_270->name = 'dy';
  $o_267->attrs[] = $o_270;
  $o_271 = new AttrSpec();
  $o_271->name = 'format';
  $o_267->attrs[] = $o_271;
  $o_272 = new AttrSpec();
  $o_272->name = 'glyphref';
  $o_267->attrs[] = $o_272;
  $o_273 = new AttrSpec();
  $o_273->name = 'x';
  $o_267->attrs[] = $o_273;
  $o_274 = new AttrSpec();
  $o_274->name = 'y';
  $o_267->attrs[] = $o_274;
  $o_267->attr_lists = ['svg-core-attributes', 'svg-presentation-attributes', 'svg-xlink-attributes'];
  $o_267->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_267->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_267;
  $o_275 = new TagSpec();
  $o_275->tag_name = 'marker';
  $o_276 = new AttrSpec();
  $o_276->name = 'class';
  $o_275->attrs[] = $o_276;
  $o_277 = new AttrSpec();
  $o_277->name = 'externalresourcesrequired';
  $o_275->attrs[] = $o_277;
  $o_278 = new AttrSpec();
  $o_278->name = 'markerunits';
  $o_275->attrs[] = $o_278;
  $o_279 = new AttrSpec();
  $o_279->name = 'markerwidth';
  $o_275->attrs[] = $o_279;
  $o_280 = new AttrSpec();
  $o_280->name = 'markerheight';
  $o_275->attrs[] = $o_280;
  $o_281 = new AttrSpec();
  $o_281->name = 'orient';
  $o_275->attrs[] = $o_281;
  $o_282 = new AttrSpec();
  $o_282->name = 'preserveaspectratio';
  $o_275->attrs[] = $o_282;
  $o_283 = new AttrSpec();
  $o_283->name = 'refx';
  $o_275->attrs[] = $o_283;
  $o_284 = new AttrSpec();
  $o_284->name = 'refy';
  $o_275->attrs[] = $o_284;
  $o_285 = new AttrSpec();
  $o_285->name = 'transform';
  $o_275->attrs[] = $o_285;
  $o_286 = new AttrSpec();
  $o_286->name = 'viewbox';
  $o_275->attrs[] = $o_286;
  $o_275->attr_lists = ['svg-core-attributes', 'svg-presentation-attributes'];
  $o_275->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_275->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_275;
  $o_287 = new TagSpec();
  $o_287->tag_name = 'path';
  $o_288 = new AttrSpec();
  $o_288->name = 'class';
  $o_287->attrs[] = $o_288;
  $o_289 = new AttrSpec();
  $o_289->name = 'd';
  $o_287->attrs[] = $o_289;
  $o_290 = new AttrSpec();
  $o_290->name = 'externalresourcesrequired';
  $o_287->attrs[] = $o_290;
  $o_291 = new AttrSpec();
  $o_291->name = 'pathlength';
  $o_287->attrs[] = $o_291;
  $o_292 = new AttrSpec();
  $o_292->name = 'sketch:type';
  $o_287->attrs[] = $o_292;
  $o_293 = new AttrSpec();
  $o_293->name = 'transform';
  $o_287->attrs[] = $o_293;
  $o_287->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_287->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_287->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_287;
  $o_294 = new TagSpec();
  $o_294->tag_name = 'svg';
  $o_295 = new AttrSpec();
  $o_295->name = 'class';
  $o_294->attrs[] = $o_295;
  $o_296 = new AttrSpec();
  $o_296->name = 'contentscripttype';
  $o_294->attrs[] = $o_296;
  $o_297 = new AttrSpec();
  $o_297->name = 'contentstyletype';
  $o_294->attrs[] = $o_297;
  $o_298 = new AttrSpec();
  $o_298->name = 'externalresourcesrequired';
  $o_294->attrs[] = $o_298;
  $o_299 = new AttrSpec();
  $o_299->name = 'height';
  $o_294->attrs[] = $o_299;
  $o_300 = new AttrSpec();
  $o_300->name = 'preserveaspectratio';
  $o_294->attrs[] = $o_300;
  $o_301 = new AttrSpec();
  $o_301->name = 'version';
  $o_301->value_regex = '(1.0|1.1)';
  $o_294->attrs[] = $o_301;
  $o_302 = new AttrSpec();
  $o_302->name = 'viewbox';
  $o_294->attrs[] = $o_302;
  $o_303 = new AttrSpec();
  $o_303->name = 'width';
  $o_294->attrs[] = $o_303;
  $o_304 = new AttrSpec();
  $o_304->name = 'x';
  $o_294->attrs[] = $o_304;
  $o_305 = new AttrSpec();
  $o_305->name = 'y';
  $o_294->attrs[] = $o_305;
  $o_306 = new AttrSpec();
  $o_306->name = 'zoomandpan';
  $o_294->attrs[] = $o_306;
  $o_294->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_294->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_294->disallowed_ancestor = ['svg'];
  $o_0->tags[] = $o_294;
  $o_307 = new TagSpec();
  $o_307->tag_name = 'view';
  $o_308 = new AttrSpec();
  $o_308->name = 'externalresourcesrequired';
  $o_307->attrs[] = $o_308;
  $o_309 = new AttrSpec();
  $o_309->name = 'preserveaspectratio';
  $o_307->attrs[] = $o_309;
  $o_310 = new AttrSpec();
  $o_310->name = 'viewbox';
  $o_307->attrs[] = $o_310;
  $o_311 = new AttrSpec();
  $o_311->name = 'viewtarget';
  $o_307->attrs[] = $o_311;
  $o_312 = new AttrSpec();
  $o_312->name = 'zoomandpan';
  $o_307->attrs[] = $o_312;
  $o_307->attr_lists = ['svg-core-attributes'];
  $o_307->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_307->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_307;
  $o_313 = new TagSpec();
  $o_313->tag_name = 'circle';
  $o_314 = new AttrSpec();
  $o_314->name = 'class';
  $o_313->attrs[] = $o_314;
  $o_315 = new AttrSpec();
  $o_315->name = 'cx';
  $o_313->attrs[] = $o_315;
  $o_316 = new AttrSpec();
  $o_316->name = 'cy';
  $o_313->attrs[] = $o_316;
  $o_317 = new AttrSpec();
  $o_317->name = 'externalresourcesrequired';
  $o_313->attrs[] = $o_317;
  $o_318 = new AttrSpec();
  $o_318->name = 'r';
  $o_313->attrs[] = $o_318;
  $o_319 = new AttrSpec();
  $o_319->name = 'sketch:type';
  $o_313->attrs[] = $o_319;
  $o_320 = new AttrSpec();
  $o_320->name = 'transform';
  $o_313->attrs[] = $o_320;
  $o_313->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_313->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_313->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_313;
  $o_321 = new TagSpec();
  $o_321->tag_name = 'line';
  $o_322 = new AttrSpec();
  $o_322->name = 'class';
  $o_321->attrs[] = $o_322;
  $o_323 = new AttrSpec();
  $o_323->name = 'externalresourcesrequired';
  $o_321->attrs[] = $o_323;
  $o_324 = new AttrSpec();
  $o_324->name = 'sketch:type';
  $o_321->attrs[] = $o_324;
  $o_325 = new AttrSpec();
  $o_325->name = 'transform';
  $o_321->attrs[] = $o_325;
  $o_326 = new AttrSpec();
  $o_326->name = 'x1';
  $o_321->attrs[] = $o_326;
  $o_327 = new AttrSpec();
  $o_327->name = 'x2';
  $o_321->attrs[] = $o_327;
  $o_328 = new AttrSpec();
  $o_328->name = 'y1';
  $o_321->attrs[] = $o_328;
  $o_329 = new AttrSpec();
  $o_329->name = 'y2';
  $o_321->attrs[] = $o_329;
  $o_321->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_321->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_321->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_321;
  $o_330 = new TagSpec();
  $o_330->tag_name = 'polygon';
  $o_331 = new AttrSpec();
  $o_331->name = 'class';
  $o_330->attrs[] = $o_331;
  $o_332 = new AttrSpec();
  $o_332->name = 'externalresourcesrequired';
  $o_330->attrs[] = $o_332;
  $o_333 = new AttrSpec();
  $o_333->name = 'points';
  $o_330->attrs[] = $o_333;
  $o_334 = new AttrSpec();
  $o_334->name = 'sketch:type';
  $o_330->attrs[] = $o_334;
  $o_335 = new AttrSpec();
  $o_335->name = 'transform';
  $o_330->attrs[] = $o_335;
  $o_330->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_330->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_330->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_330;
  $o_336 = new TagSpec();
  $o_336->tag_name = 'polyline';
  $o_337 = new AttrSpec();
  $o_337->name = 'class';
  $o_336->attrs[] = $o_337;
  $o_338 = new AttrSpec();
  $o_338->name = 'externalresourcesrequired';
  $o_336->attrs[] = $o_338;
  $o_339 = new AttrSpec();
  $o_339->name = 'points';
  $o_336->attrs[] = $o_339;
  $o_340 = new AttrSpec();
  $o_340->name = 'sketch:type';
  $o_336->attrs[] = $o_340;
  $o_341 = new AttrSpec();
  $o_341->name = 'transform';
  $o_336->attrs[] = $o_341;
  $o_336->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_336->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_336->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_336;
  $o_342 = new TagSpec();
  $o_342->tag_name = 'rect';
  $o_343 = new AttrSpec();
  $o_343->name = 'class';
  $o_342->attrs[] = $o_343;
  $o_344 = new AttrSpec();
  $o_344->name = 'externalresourcesrequired';
  $o_342->attrs[] = $o_344;
  $o_345 = new AttrSpec();
  $o_345->name = 'height';
  $o_342->attrs[] = $o_345;
  $o_346 = new AttrSpec();
  $o_346->name = 'rx';
  $o_342->attrs[] = $o_346;
  $o_347 = new AttrSpec();
  $o_347->name = 'ry';
  $o_342->attrs[] = $o_347;
  $o_348 = new AttrSpec();
  $o_348->name = 'sketch:type';
  $o_342->attrs[] = $o_348;
  $o_349 = new AttrSpec();
  $o_349->name = 'transform';
  $o_342->attrs[] = $o_349;
  $o_350 = new AttrSpec();
  $o_350->name = 'width';
  $o_342->attrs[] = $o_350;
  $o_351 = new AttrSpec();
  $o_351->name = 'x';
  $o_342->attrs[] = $o_351;
  $o_352 = new AttrSpec();
  $o_352->name = 'y';
  $o_342->attrs[] = $o_352;
  $o_342->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_342->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_342->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_342;
  $o_353 = new TagSpec();
  $o_353->tag_name = 'text';
  $o_354 = new AttrSpec();
  $o_354->name = 'class';
  $o_353->attrs[] = $o_354;
  $o_355 = new AttrSpec();
  $o_355->name = 'dx';
  $o_353->attrs[] = $o_355;
  $o_356 = new AttrSpec();
  $o_356->name = 'dy';
  $o_353->attrs[] = $o_356;
  $o_357 = new AttrSpec();
  $o_357->name = 'externalresourcesrequired';
  $o_353->attrs[] = $o_357;
  $o_358 = new AttrSpec();
  $o_358->name = 'lengthadjust';
  $o_353->attrs[] = $o_358;
  $o_359 = new AttrSpec();
  $o_359->name = 'rotate';
  $o_353->attrs[] = $o_359;
  $o_360 = new AttrSpec();
  $o_360->name = 'text-anchor';
  $o_353->attrs[] = $o_360;
  $o_361 = new AttrSpec();
  $o_361->name = 'textlength';
  $o_353->attrs[] = $o_361;
  $o_362 = new AttrSpec();
  $o_362->name = 'transform';
  $o_353->attrs[] = $o_362;
  $o_363 = new AttrSpec();
  $o_363->name = 'x';
  $o_353->attrs[] = $o_363;
  $o_364 = new AttrSpec();
  $o_364->name = 'y';
  $o_353->attrs[] = $o_364;
  $o_353->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_353->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_353->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_353;
  $o_365 = new TagSpec();
  $o_365->tag_name = 'textpath';
  $o_366 = new AttrSpec();
  $o_366->name = 'class';
  $o_365->attrs[] = $o_366;
  $o_367 = new AttrSpec();
  $o_367->name = 'externalresourcesrequired';
  $o_365->attrs[] = $o_367;
  $o_368 = new AttrSpec();
  $o_368->name = 'method';
  $o_365->attrs[] = $o_368;
  $o_369 = new AttrSpec();
  $o_369->name = 'spacing';
  $o_365->attrs[] = $o_369;
  $o_370 = new AttrSpec();
  $o_370->name = 'startoffset';
  $o_365->attrs[] = $o_370;
  $o_365->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes', 'svg-xlink-attributes'];
  $o_365->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_365->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_365;
  $o_371 = new TagSpec();
  $o_371->tag_name = 'tref';
  $o_372 = new AttrSpec();
  $o_372->name = 'class';
  $o_371->attrs[] = $o_372;
  $o_373 = new AttrSpec();
  $o_373->name = 'externalresourcesrequired';
  $o_371->attrs[] = $o_373;
  $o_371->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes', 'svg-xlink-attributes'];
  $o_371->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_371->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_371;
  $o_374 = new TagSpec();
  $o_374->tag_name = 'tspan';
  $o_375 = new AttrSpec();
  $o_375->name = 'class';
  $o_374->attrs[] = $o_375;
  $o_376 = new AttrSpec();
  $o_376->name = 'dx';
  $o_374->attrs[] = $o_376;
  $o_377 = new AttrSpec();
  $o_377->name = 'dy';
  $o_374->attrs[] = $o_377;
  $o_378 = new AttrSpec();
  $o_378->name = 'externalresourcesrequired';
  $o_374->attrs[] = $o_378;
  $o_379 = new AttrSpec();
  $o_379->name = 'rotate';
  $o_374->attrs[] = $o_379;
  $o_380 = new AttrSpec();
  $o_380->name = 'lengthadjust';
  $o_374->attrs[] = $o_380;
  $o_381 = new AttrSpec();
  $o_381->name = 'textlength';
  $o_374->attrs[] = $o_381;
  $o_382 = new AttrSpec();
  $o_382->name = 'x';
  $o_374->attrs[] = $o_382;
  $o_383 = new AttrSpec();
  $o_383->name = 'y';
  $o_374->attrs[] = $o_383;
  $o_374->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_374->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_374->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_374;
  $o_384 = new TagSpec();
  $o_384->tag_name = 'clippath';
  $o_385 = new AttrSpec();
  $o_385->name = 'class';
  $o_384->attrs[] = $o_385;
  $o_386 = new AttrSpec();
  $o_386->name = 'clippathunits';
  $o_384->attrs[] = $o_386;
  $o_387 = new AttrSpec();
  $o_387->name = 'externalresourcesrequired';
  $o_384->attrs[] = $o_387;
  $o_388 = new AttrSpec();
  $o_388->name = 'transform';
  $o_384->attrs[] = $o_388;
  $o_384->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_384->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_384->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_384;
  $o_389 = new TagSpec();
  $o_389->tag_name = 'filter';
  $o_390 = new AttrSpec();
  $o_390->name = 'class';
  $o_389->attrs[] = $o_390;
  $o_391 = new AttrSpec();
  $o_391->name = 'externalresourcesrequired';
  $o_389->attrs[] = $o_391;
  $o_392 = new AttrSpec();
  $o_392->name = 'filterres';
  $o_389->attrs[] = $o_392;
  $o_393 = new AttrSpec();
  $o_393->name = 'filterunits';
  $o_389->attrs[] = $o_393;
  $o_394 = new AttrSpec();
  $o_394->name = 'height';
  $o_389->attrs[] = $o_394;
  $o_395 = new AttrSpec();
  $o_395->name = 'primitiveunits';
  $o_389->attrs[] = $o_395;
  $o_396 = new AttrSpec();
  $o_396->name = 'width';
  $o_389->attrs[] = $o_396;
  $o_397 = new AttrSpec();
  $o_397->name = 'x';
  $o_389->attrs[] = $o_397;
  $o_398 = new AttrSpec();
  $o_398->name = 'y';
  $o_389->attrs[] = $o_398;
  $o_389->attr_lists = ['svg-core-attributes', 'svg-presentation-attributes', 'svg-xlink-attributes'];
  $o_389->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_389->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_389;
  $o_399 = new TagSpec();
  $o_399->tag_name = 'hkern';
  $o_400 = new AttrSpec();
  $o_400->name = 'g1';
  $o_399->attrs[] = $o_400;
  $o_401 = new AttrSpec();
  $o_401->name = 'g2';
  $o_399->attrs[] = $o_401;
  $o_402 = new AttrSpec();
  $o_402->name = 'k';
  $o_399->attrs[] = $o_402;
  $o_403 = new AttrSpec();
  $o_403->name = 'u1';
  $o_399->attrs[] = $o_403;
  $o_404 = new AttrSpec();
  $o_404->name = 'u2';
  $o_399->attrs[] = $o_404;
  $o_399->attr_lists = ['svg-core-attributes'];
  $o_399->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_399->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_399;
  $o_405 = new TagSpec();
  $o_405->tag_name = 'lineargradient';
  $o_406 = new AttrSpec();
  $o_406->name = 'class';
  $o_405->attrs[] = $o_406;
  $o_407 = new AttrSpec();
  $o_407->name = 'externalresourcesrequired';
  $o_405->attrs[] = $o_407;
  $o_408 = new AttrSpec();
  $o_408->name = 'gradientunits';
  $o_405->attrs[] = $o_408;
  $o_409 = new AttrSpec();
  $o_409->name = 'gradientransform';
  $o_405->attrs[] = $o_409;
  $o_410 = new AttrSpec();
  $o_410->name = 'spreadmethod';
  $o_405->attrs[] = $o_410;
  $o_411 = new AttrSpec();
  $o_411->name = 'x1';
  $o_405->attrs[] = $o_411;
  $o_412 = new AttrSpec();
  $o_412->name = 'y1';
  $o_405->attrs[] = $o_412;
  $o_413 = new AttrSpec();
  $o_413->name = 'x2';
  $o_405->attrs[] = $o_413;
  $o_414 = new AttrSpec();
  $o_414->name = 'y2';
  $o_405->attrs[] = $o_414;
  $o_405->attr_lists = ['svg-core-attributes', 'svg-presentation-attributes', 'svg-xlink-attributes'];
  $o_405->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_405->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_405;
  $o_415 = new TagSpec();
  $o_415->tag_name = 'mask';
  $o_416 = new AttrSpec();
  $o_416->name = 'class';
  $o_415->attrs[] = $o_416;
  $o_417 = new AttrSpec();
  $o_417->name = 'externalresourcesrequired';
  $o_415->attrs[] = $o_417;
  $o_418 = new AttrSpec();
  $o_418->name = 'height';
  $o_415->attrs[] = $o_418;
  $o_419 = new AttrSpec();
  $o_419->name = 'maskcontentunits';
  $o_415->attrs[] = $o_419;
  $o_420 = new AttrSpec();
  $o_420->name = 'maskunits';
  $o_415->attrs[] = $o_420;
  $o_421 = new AttrSpec();
  $o_421->name = 'width';
  $o_415->attrs[] = $o_421;
  $o_422 = new AttrSpec();
  $o_422->name = 'x';
  $o_415->attrs[] = $o_422;
  $o_423 = new AttrSpec();
  $o_423->name = 'y';
  $o_415->attrs[] = $o_423;
  $o_415->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_415->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_415->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_415;
  $o_424 = new TagSpec();
  $o_424->tag_name = 'pattern';
  $o_425 = new AttrSpec();
  $o_425->name = 'class';
  $o_424->attrs[] = $o_425;
  $o_426 = new AttrSpec();
  $o_426->name = 'externalresourcesrequired';
  $o_424->attrs[] = $o_426;
  $o_427 = new AttrSpec();
  $o_427->name = 'height';
  $o_424->attrs[] = $o_427;
  $o_428 = new AttrSpec();
  $o_428->name = 'patternunits';
  $o_424->attrs[] = $o_428;
  $o_429 = new AttrSpec();
  $o_429->name = 'patterncontentunits';
  $o_424->attrs[] = $o_429;
  $o_430 = new AttrSpec();
  $o_430->name = 'patterntransform';
  $o_424->attrs[] = $o_430;
  $o_431 = new AttrSpec();
  $o_431->name = 'preserveaspectratio';
  $o_424->attrs[] = $o_431;
  $o_432 = new AttrSpec();
  $o_432->name = 'viewbox';
  $o_424->attrs[] = $o_432;
  $o_433 = new AttrSpec();
  $o_433->name = 'width';
  $o_424->attrs[] = $o_433;
  $o_434 = new AttrSpec();
  $o_434->name = 'x';
  $o_424->attrs[] = $o_434;
  $o_435 = new AttrSpec();
  $o_435->name = 'y';
  $o_424->attrs[] = $o_435;
  $o_424->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes', 'svg-xlink-attributes'];
  $o_424->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_424->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_424;
  $o_436 = new TagSpec();
  $o_436->tag_name = 'radialgradient';
  $o_437 = new AttrSpec();
  $o_437->name = 'class';
  $o_436->attrs[] = $o_437;
  $o_438 = new AttrSpec();
  $o_438->name = 'cx';
  $o_436->attrs[] = $o_438;
  $o_439 = new AttrSpec();
  $o_439->name = 'cy';
  $o_436->attrs[] = $o_439;
  $o_440 = new AttrSpec();
  $o_440->name = 'externalresourcesrequired';
  $o_436->attrs[] = $o_440;
  $o_441 = new AttrSpec();
  $o_441->name = 'fx';
  $o_436->attrs[] = $o_441;
  $o_442 = new AttrSpec();
  $o_442->name = 'fy';
  $o_436->attrs[] = $o_442;
  $o_443 = new AttrSpec();
  $o_443->name = 'gradientunits';
  $o_436->attrs[] = $o_443;
  $o_444 = new AttrSpec();
  $o_444->name = 'gradienttransform';
  $o_436->attrs[] = $o_444;
  $o_445 = new AttrSpec();
  $o_445->name = 'r';
  $o_436->attrs[] = $o_445;
  $o_446 = new AttrSpec();
  $o_446->name = 'spreadmethod';
  $o_436->attrs[] = $o_446;
  $o_436->attr_lists = ['svg-core-attributes', 'svg-presentation-attributes', 'svg-xlink-attributes'];
  $o_436->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_436->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_436;
  $o_447 = new TagSpec();
  $o_447->tag_name = 'stop';
  $o_447->spec_name = 'lineargradient > stop';
  $o_448 = new AttrSpec();
  $o_448->name = 'offset';
  $o_447->attrs[] = $o_448;
  $o_449 = new AttrSpec();
  $o_449->name = 'stop-color';
  $o_447->attrs[] = $o_449;
  $o_450 = new AttrSpec();
  $o_450->name = 'stop-opacity';
  $o_447->attrs[] = $o_450;
  $o_447->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_447->mandatory_ancestor = 'lineargradient';
  $o_0->tags[] = $o_447;
  $o_451 = new TagSpec();
  $o_451->tag_name = 'stop';
  $o_451->spec_name = 'radialgradient > stop';
  $o_452 = new AttrSpec();
  $o_452->name = 'offset';
  $o_451->attrs[] = $o_452;
  $o_453 = new AttrSpec();
  $o_453->name = 'stop-color';
  $o_451->attrs[] = $o_453;
  $o_454 = new AttrSpec();
  $o_454->name = 'stop-opacity';
  $o_451->attrs[] = $o_454;
  $o_451->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_451->mandatory_ancestor = 'radialgradient';
  $o_0->tags[] = $o_451;
  $o_455 = new TagSpec();
  $o_455->tag_name = 'vkern';
  $o_456 = new AttrSpec();
  $o_456->name = 'g1';
  $o_455->attrs[] = $o_456;
  $o_457 = new AttrSpec();
  $o_457->name = 'g2';
  $o_455->attrs[] = $o_457;
  $o_458 = new AttrSpec();
  $o_458->name = 'k';
  $o_455->attrs[] = $o_458;
  $o_459 = new AttrSpec();
  $o_459->name = 'u1';
  $o_455->attrs[] = $o_459;
  $o_460 = new AttrSpec();
  $o_460->name = 'u2';
  $o_455->attrs[] = $o_460;
  $o_455->attr_lists = ['svg-core-attributes'];
  $o_455->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_455->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_455;
  $o_461 = new TagSpec();
  $o_461->tag_name = 'defs';
  $o_462 = new AttrSpec();
  $o_462->name = 'class';
  $o_461->attrs[] = $o_462;
  $o_463 = new AttrSpec();
  $o_463->name = 'externalresourcesrequired';
  $o_461->attrs[] = $o_463;
  $o_464 = new AttrSpec();
  $o_464->name = 'transform';
  $o_461->attrs[] = $o_464;
  $o_461->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_461->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_461->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_461;
  $o_465 = new TagSpec();
  $o_465->tag_name = 'symbol';
  $o_466 = new AttrSpec();
  $o_466->name = 'class';
  $o_465->attrs[] = $o_466;
  $o_467 = new AttrSpec();
  $o_467->name = 'externalresourcesrequired';
  $o_465->attrs[] = $o_467;
  $o_468 = new AttrSpec();
  $o_468->name = 'preserveaspectratio';
  $o_465->attrs[] = $o_468;
  $o_469 = new AttrSpec();
  $o_469->name = 'viewbox';
  $o_465->attrs[] = $o_469;
  $o_465->attr_lists = ['svg-core-attributes', 'svg-presentation-attributes'];
  $o_465->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_465->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_465;
  $o_470 = new TagSpec();
  $o_470->tag_name = 'use';
  $o_471 = new AttrSpec();
  $o_471->name = 'class';
  $o_470->attrs[] = $o_471;
  $o_472 = new AttrSpec();
  $o_472->name = 'externalresourcesrequired';
  $o_470->attrs[] = $o_472;
  $o_473 = new AttrSpec();
  $o_473->name = 'height';
  $o_470->attrs[] = $o_473;
  $o_474 = new AttrSpec();
  $o_474->name = 'transform';
  $o_470->attrs[] = $o_474;
  $o_475 = new AttrSpec();
  $o_475->name = 'width';
  $o_470->attrs[] = $o_475;
  $o_476 = new AttrSpec();
  $o_476->name = 'x';
  $o_470->attrs[] = $o_476;
  $o_477 = new AttrSpec();
  $o_477->name = 'y';
  $o_470->attrs[] = $o_477;
  $o_470->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes', 'svg-xlink-attributes'];
  $o_470->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_470->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_470;
  $o_478 = new TagSpec();
  $o_478->tag_name = 'foreignobject';
  $o_479 = new AttrSpec();
  $o_479->name = 'class';
  $o_478->attrs[] = $o_479;
  $o_480 = new AttrSpec();
  $o_480->name = 'externalresourcesrequired';
  $o_478->attrs[] = $o_480;
  $o_481 = new AttrSpec();
  $o_481->name = 'height';
  $o_478->attrs[] = $o_481;
  $o_482 = new AttrSpec();
  $o_482->name = 'transform';
  $o_478->attrs[] = $o_482;
  $o_483 = new AttrSpec();
  $o_483->name = 'width';
  $o_478->attrs[] = $o_483;
  $o_484 = new AttrSpec();
  $o_484->name = 'x';
  $o_478->attrs[] = $o_484;
  $o_485 = new AttrSpec();
  $o_485->name = 'y';
  $o_478->attrs[] = $o_485;
  $o_478->attr_lists = ['svg-conditional-processing-attributes', 'svg-core-attributes', 'svg-presentation-attributes'];
  $o_478->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_478->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_478;
  $o_486 = new TagSpec();
  $o_486->tag_name = 'desc';
  $o_487 = new AttrSpec();
  $o_487->name = 'class';
  $o_486->attrs[] = $o_487;
  $o_486->attr_lists = ['svg-core-attributes'];
  $o_486->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_486->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_486;
  $o_488 = new TagSpec();
  $o_488->tag_name = 'title';
  $o_488->spec_name = 'svg title';
  $o_489 = new AttrSpec();
  $o_489->name = 'class';
  $o_488->attrs[] = $o_489;
  $o_488->attr_lists = ['svg-core-attributes'];
  $o_488->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#svg';
  $o_488->mandatory_ancestor = 'svg';
  $o_0->tags[] = $o_488;
  $o_490 = new TagSpec();
  $o_490->tag_name = 'table';
  $o_491 = new AttrSpec();
  $o_491->name = 'sortable';
  $o_490->attrs[] = $o_491;
  $o_492 = new AttrSpec();
  $o_492->name = 'align';
  $o_490->attrs[] = $o_492;
  $o_493 = new AttrSpec();
  $o_493->name = 'border';
  $o_493->value_regex = '0|1';
  $o_490->attrs[] = $o_493;
  $o_494 = new AttrSpec();
  $o_494->name = 'bgcolor';
  $o_490->attrs[] = $o_494;
  $o_495 = new AttrSpec();
  $o_495->name = 'cellpadding';
  $o_490->attrs[] = $o_495;
  $o_496 = new AttrSpec();
  $o_496->name = 'cellspacing';
  $o_490->attrs[] = $o_496;
  $o_497 = new AttrSpec();
  $o_497->name = 'width';
  $o_490->attrs[] = $o_497;
  $o_0->tags[] = $o_490;
  $o_498 = new TagSpec();
  $o_498->tag_name = 'caption';
  $o_0->tags[] = $o_498;
  $o_499 = new TagSpec();
  $o_499->tag_name = 'colgroup';
  $o_500 = new AttrSpec();
  $o_500->name = 'span';
  $o_499->attrs[] = $o_500;
  $o_0->tags[] = $o_499;
  $o_501 = new TagSpec();
  $o_501->tag_name = 'col';
  $o_502 = new AttrSpec();
  $o_502->name = 'span';
  $o_501->attrs[] = $o_502;
  $o_0->tags[] = $o_501;
  $o_503 = new TagSpec();
  $o_503->tag_name = 'tbody';
  $o_0->tags[] = $o_503;
  $o_504 = new TagSpec();
  $o_504->tag_name = 'thead';
  $o_0->tags[] = $o_504;
  $o_505 = new TagSpec();
  $o_505->tag_name = 'tfoot';
  $o_0->tags[] = $o_505;
  $o_506 = new TagSpec();
  $o_506->tag_name = 'tr';
  $o_507 = new AttrSpec();
  $o_507->name = 'align';
  $o_506->attrs[] = $o_507;
  $o_508 = new AttrSpec();
  $o_508->name = 'bgcolor';
  $o_506->attrs[] = $o_508;
  $o_509 = new AttrSpec();
  $o_509->name = 'height';
  $o_506->attrs[] = $o_509;
  $o_510 = new AttrSpec();
  $o_510->name = 'valign';
  $o_506->attrs[] = $o_510;
  $o_0->tags[] = $o_506;
  $o_511 = new TagSpec();
  $o_511->tag_name = 'td';
  $o_512 = new AttrSpec();
  $o_512->name = 'colspan';
  $o_511->attrs[] = $o_512;
  $o_513 = new AttrSpec();
  $o_513->name = 'headers';
  $o_511->attrs[] = $o_513;
  $o_514 = new AttrSpec();
  $o_514->name = 'rowspan';
  $o_511->attrs[] = $o_514;
  $o_515 = new AttrSpec();
  $o_515->name = 'align';
  $o_511->attrs[] = $o_515;
  $o_516 = new AttrSpec();
  $o_516->name = 'bgcolor';
  $o_511->attrs[] = $o_516;
  $o_517 = new AttrSpec();
  $o_517->name = 'height';
  $o_511->attrs[] = $o_517;
  $o_518 = new AttrSpec();
  $o_518->name = 'valign';
  $o_511->attrs[] = $o_518;
  $o_519 = new AttrSpec();
  $o_519->name = 'width';
  $o_511->attrs[] = $o_519;
  $o_0->tags[] = $o_511;
  $o_520 = new TagSpec();
  $o_520->tag_name = 'th';
  $o_521 = new AttrSpec();
  $o_521->name = 'abbr';
  $o_520->attrs[] = $o_521;
  $o_522 = new AttrSpec();
  $o_522->name = 'colspan';
  $o_520->attrs[] = $o_522;
  $o_523 = new AttrSpec();
  $o_523->name = 'headers';
  $o_520->attrs[] = $o_523;
  $o_524 = new AttrSpec();
  $o_524->name = 'rowspan';
  $o_520->attrs[] = $o_524;
  $o_525 = new AttrSpec();
  $o_525->name = 'scope';
  $o_520->attrs[] = $o_525;
  $o_526 = new AttrSpec();
  $o_526->name = 'sorted';
  $o_520->attrs[] = $o_526;
  $o_527 = new AttrSpec();
  $o_527->name = 'align';
  $o_520->attrs[] = $o_527;
  $o_528 = new AttrSpec();
  $o_528->name = 'bgcolor';
  $o_520->attrs[] = $o_528;
  $o_529 = new AttrSpec();
  $o_529->name = 'height';
  $o_520->attrs[] = $o_529;
  $o_530 = new AttrSpec();
  $o_530->name = 'valign';
  $o_520->attrs[] = $o_530;
  $o_531 = new AttrSpec();
  $o_531->name = 'width';
  $o_520->attrs[] = $o_531;
  $o_0->tags[] = $o_520;
  $o_532 = new TagSpec();
  $o_532->tag_name = 'button';
  $o_533 = new AttrSpec();
  $o_533->name = 'disabled';
  $o_533->value = '';
  $o_532->attrs[] = $o_533;
  $o_534 = new AttrSpec();
  $o_534->name = 'name';
  $o_532->attrs[] = $o_534;
  $o_535 = new AttrSpec();
  $o_535->name = 'role';
  $o_535->implicit = true;
  $o_532->attrs[] = $o_535;
  $o_536 = new AttrSpec();
  $o_536->name = 'tabindex';
  $o_536->implicit = true;
  $o_532->attrs[] = $o_536;
  $o_537 = new AttrSpec();
  $o_537->name = 'type';
  $o_532->attrs[] = $o_537;
  $o_538 = new AttrSpec();
  $o_538->name = 'value';
  $o_532->attrs[] = $o_538;
  $o_0->tags[] = $o_532;
  $o_539 = new TagSpec();
  $o_539->tag_name = 'script';
  $o_539->spec_name = 'amphtml engine v0.js script';
  $o_539->mandatory = true;
  $o_539->unique = true;
  $o_539->mandatory_parent = 'head';
  $o_540 = new AttrSpec();
  $o_540->name = 'async';
  $o_540->mandatory = true;
  $o_540->value = '';
  $o_539->attrs[] = $o_540;
  $o_541 = new AttrSpec();
  $o_541->name = 'src';
  $o_541->mandatory = true;
  $o_541->value = 'https://cdn.ampproject.org/v0.js';
  $o_541->dispatch_key = true;
  $o_539->attrs[] = $o_541;
  $o_542 = new AttrSpec();
  $o_542->name = 'type';
  $o_542->value = 'text/javascript';
  $o_539->attrs[] = $o_542;
  $o_539->spec_url = 'https://www.ampproject.org/docs/reference/spec.html#required-markup';
  $o_543 = new CdataSpec();
  $o_544 = new BlackListedCDataRegex();
  $o_544->regex = '.';
  $o_544->error_message = 'contents';
  $o_543->blacklisted_cdata_regex[] = $o_544;
  $o_539->cdata = $o_543;
  $o_0->tags[] = $o_539;
  $o_545 = new TagSpec();
  $o_545->tag_name = 'script';
  $o_545->spec_name = 'script type=application/ld+json';
  $o_546 = new AttrSpec();
  $o_546->name = 'type';
  $o_546->mandatory = true;
  $o_546->value = 'application/ld+json';
  $o_546->dispatch_key = true;
  $o_545->attrs[] = $o_546;
  $o_547 = new CdataSpec();
  $o_548 = new BlackListedCDataRegex();
  $o_548->regex = '<!--';
  $o_548->error_message = 'html comments';
  $o_547->blacklisted_cdata_regex[] = $o_548;
  $o_545->cdata = $o_547;
  $o_0->tags[] = $o_545;
  $o_549 = new TagSpec();
  $o_549->tag_name = 'noscript';
  $o_549->spec_name = 'noscript enclosure for boilerplate';
  $o_549->mandatory = true;
  $o_549->unique = true;
  $o_549->mandatory_parent = 'head';
  $o_549->spec_url = 'https://github.com/ampproject/amphtml/blob/master/spec/amp-boilerplate.md';
  $o_0->tags[] = $o_549;
  $o_550 = new TagSpec();
  $o_550->tag_name = 'noscript';
  $o_550->disallowed_ancestor = ['noscript'];
  $o_550->mandatory_ancestor = 'body';
  $o_0->tags[] = $o_550;
  $o_551 = new TagSpec();
  $o_551->tag_name = 'acronym';
  $o_0->tags[] = $o_551;
  $o_552 = new TagSpec();
  $o_552->tag_name = 'big';
  $o_0->tags[] = $o_552;
  $o_553 = new TagSpec();
  $o_553->tag_name = 'center';
  $o_0->tags[] = $o_553;
  $o_554 = new TagSpec();
  $o_554->tag_name = 'dir';
  $o_0->tags[] = $o_554;
  $o_555 = new TagSpec();
  $o_555->tag_name = 'hgroup';
  $o_0->tags[] = $o_555;
  $o_556 = new TagSpec();
  $o_556->tag_name = 'listing';
  $o_0->tags[] = $o_556;
  $o_557 = new TagSpec();
  $o_557->tag_name = 'multicol';
  $o_0->tags[] = $o_557;
  $o_558 = new TagSpec();
  $o_558->tag_name = 'nextid';
  $o_0->tags[] = $o_558;
  $o_559 = new TagSpec();
  $o_559->tag_name = 'nobr';
  $o_0->tags[] = $o_559;
  $o_560 = new TagSpec();
  $o_560->tag_name = 'spacer';
  $o_0->tags[] = $o_560;
  $o_561 = new TagSpec();
  $o_561->tag_name = 'strike';
  $o_0->tags[] = $o_561;
  $o_562 = new TagSpec();
  $o_562->tag_name = 'tt';
  $o_0->tags[] = $o_562;
  $o_563 = new TagSpec();
  $o_563->tag_name = 'xmp';
  $o_0->tags[] = $o_563;
  $o_564 = new TagSpec();
  $o_564->tag_name = 'o:p';
  $o_0->tags[] = $o_564;
  $o_565 = new TagSpec();
  $o_565->tag_name = 'amp-ad';
  $o_566 = new AttrSpec();
  $o_566->name = 'alt';
  $o_565->attrs[] = $o_566;
  $o_567 = new AttrSpec();
  $o_567->name = 'json';
  $o_565->attrs[] = $o_567;
  $o_568 = new AttrSpec();
  $o_568->name = 'src';
  $o_569 = new UrlSpec();
  $o_569->allowed_protocol = ['https'];
  $o_569->allow_relative = true;
  $o_568->value_url = $o_569;
  $o_565->attrs[] = $o_568;
  $o_570 = new AttrSpec();
  $o_570->name = 'type';
  $o_570->mandatory = true;
  $o_565->attrs[] = $o_570;
  $o_565->attr_lists = ['extended-amp-global'];
  $o_565->spec_url = 'https://www.ampproject.org/docs/reference/amp-ad.html';
  $o_571 = new AmpLayout();
  $o_571->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_565->amp_layout = $o_571;
  $o_565->disallowed_ancestor = ['amp-sidebar'];
  $o_0->tags[] = $o_565;
  $o_572 = new TagSpec();
  $o_572->tag_name = 'amp-embed';
  $o_573 = new AttrSpec();
  $o_573->name = 'alt';
  $o_572->attrs[] = $o_573;
  $o_574 = new AttrSpec();
  $o_574->name = 'json';
  $o_572->attrs[] = $o_574;
  $o_575 = new AttrSpec();
  $o_575->name = 'src';
  $o_576 = new UrlSpec();
  $o_576->allowed_protocol = ['https'];
  $o_576->allow_relative = true;
  $o_575->value_url = $o_576;
  $o_572->attrs[] = $o_575;
  $o_577 = new AttrSpec();
  $o_577->name = 'type';
  $o_577->mandatory = true;
  $o_572->attrs[] = $o_577;
  $o_572->attr_lists = ['extended-amp-global'];
  $o_572->spec_url = 'https://www.ampproject.org/docs/reference/amp-embed.html';
  $o_578 = new AmpLayout();
  $o_578->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_572->amp_layout = $o_578;
  $o_572->disallowed_ancestor = ['amp-sidebar'];
  $o_0->tags[] = $o_572;
  $o_579 = new TagSpec();
  $o_579->tag_name = 'amp-img';
  $o_580 = new AttrSpec();
  $o_580->name = 'alt';
  $o_579->attrs[] = $o_580;
  $o_581 = new AttrSpec();
  $o_581->name = 'attribution';
  $o_579->attrs[] = $o_581;
  $o_582 = new AttrSpec();
  $o_582->name = 'placeholder';
  $o_579->attrs[] = $o_582;
  $o_579->attr_lists = ['extended-amp-global', 'mandatory-src-or-srcset'];
  $o_579->spec_url = 'https://www.ampproject.org/docs/reference/amp-img.html';
  $o_583 = new AmpLayout();
  $o_583->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_579->amp_layout = $o_583;
  $o_0->tags[] = $o_579;
  $o_584 = new TagSpec();
  $o_584->tag_name = 'amp-pixel';
  $o_585 = new AttrSpec();
  $o_585->name = 'src';
  $o_585->mandatory = true;
  $o_586 = new UrlSpec();
  $o_586->allowed_protocol = ['https'];
  $o_586->allow_relative = true;
  $o_585->value_url = $o_586;
  $o_584->attrs[] = $o_585;
  $o_584->attr_lists = ['extended-amp-global'];
  $o_584->spec_url = 'https://www.ampproject.org/docs/reference/amp-pixel.html';
  $o_587 = new AmpLayout();
  $o_587->supported_layouts = [AmpLayoutLayout::FIXED, AmpLayoutLayout::NODISPLAY];
  $o_587->defines_default_width = true;
  $o_587->defines_default_height = true;
  $o_584->amp_layout = $o_587;
  $o_584->disallowed_ancestor = ['amp-sidebar'];
  $o_0->tags[] = $o_584;
  $o_588 = new TagSpec();
  $o_588->tag_name = 'amp-video';
  $o_589 = new AttrSpec();
  $o_589->name = 'alt';
  $o_588->attrs[] = $o_589;
  $o_590 = new AttrSpec();
  $o_590->name = 'attribution';
  $o_588->attrs[] = $o_590;
  $o_591 = new AttrSpec();
  $o_591->name = 'autoplay';
  $o_591->value = '';
  $o_588->attrs[] = $o_591;
  $o_592 = new AttrSpec();
  $o_592->name = 'controls';
  $o_592->value = '';
  $o_588->attrs[] = $o_592;
  $o_593 = new AttrSpec();
  $o_593->name = 'loop';
  $o_593->value = '';
  $o_588->attrs[] = $o_593;
  $o_594 = new AttrSpec();
  $o_594->name = 'muted';
  $o_594->value = '';
  $o_588->attrs[] = $o_594;
  $o_595 = new AttrSpec();
  $o_595->name = 'placeholder';
  $o_588->attrs[] = $o_595;
  $o_596 = new AttrSpec();
  $o_596->name = 'poster';
  $o_588->attrs[] = $o_596;
  $o_597 = new AttrSpec();
  $o_597->name = 'preload';
  $o_597->value_regex = '(none|metadata|auto|)';
  $o_588->attrs[] = $o_597;
  $o_598 = new AttrSpec();
  $o_598->name = 'src';
  $o_599 = new UrlSpec();
  $o_599->allowed_protocol = ['https'];
  $o_599->allow_relative = true;
  $o_598->value_url = $o_599;
  $o_588->attrs[] = $o_598;
  $o_588->attr_lists = ['extended-amp-global'];
  $o_588->spec_url = 'https://www.ampproject.org/docs/reference/amp-video.html';
  $o_600 = new AmpLayout();
  $o_600->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_588->amp_layout = $o_600;
  $o_588->disallowed_ancestor = ['amp-sidebar'];
  $o_0->tags[] = $o_588;
  $o_601 = new TagSpec();
  $o_601->tag_name = 'script';
  $o_601->spec_name = 'amp-access extension .js script';
  $o_601->mandatory_parent = 'head';
  $o_602 = new AttrSpec();
  $o_602->name = 'async';
  $o_602->mandatory = true;
  $o_602->value = '';
  $o_601->attrs[] = $o_602;
  $o_603 = new AttrSpec();
  $o_603->name = 'custom-element';
  $o_603->mandatory = true;
  $o_603->value = 'amp-access';
  $o_603->dispatch_key = true;
  $o_601->attrs[] = $o_603;
  $o_604 = new AttrSpec();
  $o_604->name = 'src';
  $o_604->mandatory = true;
  $o_604->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-access-(latest|0\\.1).js';
  $o_601->attrs[] = $o_604;
  $o_605 = new AttrSpec();
  $o_605->name = 'type';
  $o_605->value = 'text/javascript';
  $o_601->attrs[] = $o_605;
  $o_601->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-access.html';
  $o_606 = new CdataSpec();
  $o_607 = new BlackListedCDataRegex();
  $o_607->regex = '.';
  $o_607->error_message = 'contents';
  $o_606->blacklisted_cdata_regex[] = $o_607;
  $o_601->cdata = $o_606;
  $o_0->tags[] = $o_601;
  $o_608 = new TagSpec();
  $o_608->tag_name = 'script';
  $o_608->spec_name = 'amp-access extension .json script';
  $o_608->mandatory_parent = 'head';
  $o_609 = new AttrSpec();
  $o_609->name = 'id';
  $o_609->mandatory = true;
  $o_609->value = 'amp-access';
  $o_609->dispatch_key = true;
  $o_608->attrs[] = $o_609;
  $o_610 = new AttrSpec();
  $o_610->name = 'type';
  $o_610->mandatory = true;
  $o_610->value = 'application/json';
  $o_608->attrs[] = $o_610;
  $o_608->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-access-spec.html';
  $o_611 = new CdataSpec();
  $o_612 = new BlackListedCDataRegex();
  $o_612->regex = '<!--';
  $o_612->error_message = 'html comments';
  $o_611->blacklisted_cdata_regex[] = $o_612;
  $o_608->cdata = $o_611;
  $o_608->also_requires_tag = ['amp-access extension .js script', 'amp-analytics extension .js script'];
  $o_0->tags[] = $o_608;
  $o_613 = new TagSpec();
  $o_613->tag_name = 'script';
  $o_613->spec_name = 'amp-accordion extension .js script';
  $o_613->mandatory_parent = 'head';
  $o_614 = new AttrSpec();
  $o_614->name = 'async';
  $o_614->mandatory = true;
  $o_614->value = '';
  $o_613->attrs[] = $o_614;
  $o_615 = new AttrSpec();
  $o_615->name = 'custom-element';
  $o_615->mandatory = true;
  $o_615->value = 'amp-accordion';
  $o_615->dispatch_key = true;
  $o_613->attrs[] = $o_615;
  $o_616 = new AttrSpec();
  $o_616->name = 'src';
  $o_616->mandatory = true;
  $o_616->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-accordion-(latest|0\\.1).js';
  $o_613->attrs[] = $o_616;
  $o_617 = new AttrSpec();
  $o_617->name = 'type';
  $o_617->value = 'text/javascript';
  $o_613->attrs[] = $o_617;
  $o_613->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-accordion.html';
  $o_618 = new CdataSpec();
  $o_619 = new BlackListedCDataRegex();
  $o_619->regex = '.';
  $o_619->error_message = 'contents';
  $o_618->blacklisted_cdata_regex[] = $o_619;
  $o_613->cdata = $o_618;
  $o_0->tags[] = $o_613;
  $o_620 = new TagSpec();
  $o_620->tag_name = 'amp-accordion';
  $o_621 = new AttrSpec();
  $o_621->name = 'animate';
  $o_621->value = '';
  $o_620->attrs[] = $o_621;
  $o_620->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-accordion.html';
  $o_622 = new AmpLayout();
  $o_622->supported_layouts = [AmpLayoutLayout::CONTAINER];
  $o_620->amp_layout = $o_622;
  $o_620->disallowed_ancestor = ['head'];
  $o_620->also_requires_tag = ['amp-accordion extension .js script'];
  $o_623 = new ChildTagSpec();
  $o_623->child_tag_name_oneof = ['section'];
  $o_620->child_tags = $o_623;
  $o_0->tags[] = $o_620;
  $o_624 = new TagSpec();
  $o_624->tag_name = 'section';
  $o_624->spec_name = 'amp-accordion > section';
  $o_624->mandatory_parent = 'amp-accordion';
  $o_625 = new AttrSpec();
  $o_625->name = 'expanded';
  $o_625->value = '';
  $o_624->attrs[] = $o_625;
  $o_624->disallowed_ancestor = ['head'];
  $o_626 = new ChildTagSpec();
  $o_626->mandatory_num_child_tags = 2;
  $o_626->first_child_tag_name_oneof = ['h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header'];
  $o_624->child_tags = $o_626;
  $o_0->tags[] = $o_624;
  $o_627 = new TagSpec();
  $o_627->tag_name = 'script';
  $o_627->spec_name = 'amp-analytics extension .js script';
  $o_627->mandatory_parent = 'head';
  $o_628 = new AttrSpec();
  $o_628->name = 'async';
  $o_628->mandatory = true;
  $o_628->value = '';
  $o_627->attrs[] = $o_628;
  $o_629 = new AttrSpec();
  $o_629->name = 'custom-element';
  $o_629->mandatory = true;
  $o_629->value = 'amp-analytics';
  $o_629->dispatch_key = true;
  $o_627->attrs[] = $o_629;
  $o_630 = new AttrSpec();
  $o_630->name = 'src';
  $o_630->mandatory = true;
  $o_630->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-analytics-(latest|0\\.1).js';
  $o_627->attrs[] = $o_630;
  $o_631 = new AttrSpec();
  $o_631->name = 'type';
  $o_631->value = 'text/javascript';
  $o_627->attrs[] = $o_631;
  $o_627->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-analytics.html';
  $o_632 = new CdataSpec();
  $o_633 = new BlackListedCDataRegex();
  $o_633->regex = '.';
  $o_633->error_message = 'contents';
  $o_632->blacklisted_cdata_regex[] = $o_633;
  $o_627->cdata = $o_632;
  $o_0->tags[] = $o_627;
  $o_634 = new TagSpec();
  $o_634->tag_name = 'script';
  $o_634->spec_name = 'amp-analytics extension .json script';
  $o_634->mandatory_parent = 'amp-analytics';
  $o_635 = new AttrSpec();
  $o_635->name = 'type';
  $o_635->mandatory = true;
  $o_635->value = 'application/json';
  $o_635->dispatch_key = true;
  $o_634->attrs[] = $o_635;
  $o_634->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-analytics.html';
  $o_636 = new CdataSpec();
  $o_637 = new BlackListedCDataRegex();
  $o_637->regex = '<!--';
  $o_637->error_message = 'html comments';
  $o_636->blacklisted_cdata_regex[] = $o_637;
  $o_634->cdata = $o_636;
  $o_0->tags[] = $o_634;
  $o_638 = new TagSpec();
  $o_638->tag_name = 'script';
  $o_638->spec_name = 'amp-ad-metadata .json script';
  $o_638->mandatory_parent = 'body';
  $o_639 = new AttrSpec();
  $o_639->name = 'type';
  $o_639->mandatory = true;
  $o_639->value = 'application/json';
  $o_638->attrs[] = $o_639;
  $o_640 = new AttrSpec();
  $o_640->name = 'amp-ad-metadata';
  $o_640->mandatory = true;
  $o_640->value = '';
  $o_640->dispatch_key = true;
  $o_638->attrs[] = $o_640;
  $o_638->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-analytics.html';
  $o_641 = new CdataSpec();
  $o_642 = new BlackListedCDataRegex();
  $o_642->regex = '<!--';
  $o_642->error_message = 'html comments';
  $o_641->blacklisted_cdata_regex[] = $o_642;
  $o_638->cdata = $o_641;
  $o_0->tags[] = $o_638;
  $o_643 = new TagSpec();
  $o_643->tag_name = 'amp-analytics';
  $o_644 = new AttrSpec();
  $o_644->name = 'type';
  $o_643->attrs[] = $o_644;
  $o_645 = new AttrSpec();
  $o_645->name = 'config';
  $o_646 = new UrlSpec();
  $o_646->allowed_protocol = ['https'];
  $o_646->allow_relative = true;
  $o_645->value_url = $o_646;
  $o_643->attrs[] = $o_645;
  $o_643->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-analytics.html';
  $o_643->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_643->also_requires_tag = ['amp-analytics extension .js script'];
  $o_0->tags[] = $o_643;
  $o_647 = new TagSpec();
  $o_647->tag_name = 'script';
  $o_647->spec_name = 'amp-anim extension .js script';
  $o_647->mandatory_parent = 'head';
  $o_648 = new AttrSpec();
  $o_648->name = 'async';
  $o_648->mandatory = true;
  $o_648->value = '';
  $o_647->attrs[] = $o_648;
  $o_649 = new AttrSpec();
  $o_649->name = 'custom-element';
  $o_649->mandatory = true;
  $o_649->value = 'amp-anim';
  $o_649->dispatch_key = true;
  $o_647->attrs[] = $o_649;
  $o_650 = new AttrSpec();
  $o_650->name = 'src';
  $o_650->mandatory = true;
  $o_650->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-anim-(latest|0\\.1).js';
  $o_647->attrs[] = $o_650;
  $o_651 = new AttrSpec();
  $o_651->name = 'type';
  $o_651->value = 'text/javascript';
  $o_647->attrs[] = $o_651;
  $o_647->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-anim.html';
  $o_652 = new CdataSpec();
  $o_653 = new BlackListedCDataRegex();
  $o_653->regex = '.';
  $o_653->error_message = 'contents';
  $o_652->blacklisted_cdata_regex[] = $o_653;
  $o_647->cdata = $o_652;
  $o_0->tags[] = $o_647;
  $o_654 = new TagSpec();
  $o_654->tag_name = 'amp-anim';
  $o_655 = new AttrSpec();
  $o_655->name = 'alt';
  $o_654->attrs[] = $o_655;
  $o_656 = new AttrSpec();
  $o_656->name = 'attribution';
  $o_654->attrs[] = $o_656;
  $o_657 = new AttrSpec();
  $o_657->name = 'autoplay';
  $o_657->value = '';
  $o_654->attrs[] = $o_657;
  $o_658 = new AttrSpec();
  $o_658->name = 'controls';
  $o_654->attrs[] = $o_658;
  $o_654->attr_lists = ['extended-amp-global', 'mandatory-src-or-srcset'];
  $o_654->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-anim.html';
  $o_659 = new AmpLayout();
  $o_659->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_654->amp_layout = $o_659;
  $o_654->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_654->also_requires_tag = ['amp-anim extension .js script'];
  $o_0->tags[] = $o_654;
  $o_660 = new TagSpec();
  $o_660->tag_name = 'script';
  $o_660->spec_name = 'amp-audio extension .js script';
  $o_660->mandatory_parent = 'head';
  $o_661 = new AttrSpec();
  $o_661->name = 'async';
  $o_661->mandatory = true;
  $o_661->value = '';
  $o_660->attrs[] = $o_661;
  $o_662 = new AttrSpec();
  $o_662->name = 'custom-element';
  $o_662->mandatory = true;
  $o_662->value = 'amp-audio';
  $o_662->dispatch_key = true;
  $o_660->attrs[] = $o_662;
  $o_663 = new AttrSpec();
  $o_663->name = 'src';
  $o_663->mandatory = true;
  $o_663->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-audio-(latest|0\\.1).js';
  $o_660->attrs[] = $o_663;
  $o_664 = new AttrSpec();
  $o_664->name = 'type';
  $o_664->value = 'text/javascript';
  $o_660->attrs[] = $o_664;
  $o_660->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-audio.html';
  $o_665 = new CdataSpec();
  $o_666 = new BlackListedCDataRegex();
  $o_666->regex = '.';
  $o_666->error_message = 'contents';
  $o_665->blacklisted_cdata_regex[] = $o_666;
  $o_660->cdata = $o_665;
  $o_0->tags[] = $o_660;
  $o_667 = new TagSpec();
  $o_667->tag_name = 'amp-audio';
  $o_668 = new AttrSpec();
  $o_668->name = 'autoplay';
  $o_668->value_regex = '^$|desktop|tablet|mobile|autoplay';
  $o_667->attrs[] = $o_668;
  $o_669 = new AttrSpec();
  $o_669->name = 'controls';
  $o_667->attrs[] = $o_669;
  $o_670 = new AttrSpec();
  $o_670->name = 'loop';
  $o_670->value = '';
  $o_667->attrs[] = $o_670;
  $o_671 = new AttrSpec();
  $o_671->name = 'muted';
  $o_671->value = '';
  $o_667->attrs[] = $o_671;
  $o_672 = new AttrSpec();
  $o_672->name = 'src';
  $o_673 = new UrlSpec();
  $o_673->allowed_protocol = ['https'];
  $o_673->allow_relative = true;
  $o_672->value_url = $o_673;
  $o_667->attrs[] = $o_672;
  $o_667->attr_lists = ['extended-amp-global'];
  $o_667->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-audio.html';
  $o_674 = new AmpLayout();
  $o_674->supported_layouts = [AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::NODISPLAY];
  $o_674->defines_default_width = true;
  $o_674->defines_default_height = true;
  $o_667->amp_layout = $o_674;
  $o_667->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_667->also_requires_tag = ['amp-audio extension .js script'];
  $o_0->tags[] = $o_667;
  $o_675 = new TagSpec();
  $o_675->tag_name = 'script';
  $o_675->spec_name = 'amp-brid-player extension .js script';
  $o_675->mandatory_parent = 'head';
  $o_676 = new AttrSpec();
  $o_676->name = 'async';
  $o_676->mandatory = true;
  $o_676->value = '';
  $o_675->attrs[] = $o_676;
  $o_677 = new AttrSpec();
  $o_677->name = 'custom-element';
  $o_677->mandatory = true;
  $o_677->value = 'amp-brid-player';
  $o_677->dispatch_key = true;
  $o_675->attrs[] = $o_677;
  $o_678 = new AttrSpec();
  $o_678->name = 'src';
  $o_678->mandatory = true;
  $o_678->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-brid-player-(latest|0\\.1).js';
  $o_675->attrs[] = $o_678;
  $o_679 = new AttrSpec();
  $o_679->name = 'type';
  $o_679->value = 'text/javascript';
  $o_675->attrs[] = $o_679;
  $o_675->spec_url = 'https://github.com/ampproject/amphtml/blob/master/extensions/amp-brid-player/amp-brid-player.md';
  $o_680 = new CdataSpec();
  $o_681 = new BlackListedCDataRegex();
  $o_681->regex = '.';
  $o_681->error_message = 'contents';
  $o_680->blacklisted_cdata_regex[] = $o_681;
  $o_675->cdata = $o_680;
  $o_0->tags[] = $o_675;
  $o_682 = new TagSpec();
  $o_682->tag_name = 'amp-brid-player';
  $o_683 = new AttrSpec();
  $o_683->name = 'data-partner';
  $o_683->mandatory = true;
  $o_683->value_regex = '[0-9]+';
  $o_682->attrs[] = $o_683;
  $o_684 = new AttrSpec();
  $o_684->name = 'data-player';
  $o_684->mandatory = true;
  $o_684->value_regex = '[0-9]+';
  $o_682->attrs[] = $o_684;
  $o_685 = new AttrSpec();
  $o_685->name = 'data-playlist';
  $o_685->mandatory_oneof = '[\'data-playlist\', \'data-video\']';
  $o_685->value_regex = '[0-9]+';
  $o_682->attrs[] = $o_685;
  $o_686 = new AttrSpec();
  $o_686->name = 'data-video';
  $o_686->mandatory_oneof = '[\'data-playlist\', \'data-video\']';
  $o_686->value_regex = '[0-9]+';
  $o_682->attrs[] = $o_686;
  $o_682->attr_lists = ['extended-amp-global'];
  $o_682->spec_url = 'https://github.com/ampproject/amphtml/blob/master/extensions/amp-brid-player/amp-brid-player.md';
  $o_687 = new AmpLayout();
  $o_687->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_682->amp_layout = $o_687;
  $o_682->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_682->also_requires_tag = ['amp-brid-player extension .js script'];
  $o_0->tags[] = $o_682;
  $o_688 = new TagSpec();
  $o_688->tag_name = 'script';
  $o_688->spec_name = 'amp-brightcove extension .js script';
  $o_688->mandatory_parent = 'head';
  $o_689 = new AttrSpec();
  $o_689->name = 'async';
  $o_689->mandatory = true;
  $o_689->value = '';
  $o_688->attrs[] = $o_689;
  $o_690 = new AttrSpec();
  $o_690->name = 'custom-element';
  $o_690->mandatory = true;
  $o_690->value = 'amp-brightcove';
  $o_690->dispatch_key = true;
  $o_688->attrs[] = $o_690;
  $o_691 = new AttrSpec();
  $o_691->name = 'src';
  $o_691->mandatory = true;
  $o_691->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-brightcove-(latest|0\\.1).js';
  $o_688->attrs[] = $o_691;
  $o_692 = new AttrSpec();
  $o_692->name = 'type';
  $o_692->value = 'text/javascript';
  $o_688->attrs[] = $o_692;
  $o_688->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-brightcove.html';
  $o_693 = new CdataSpec();
  $o_694 = new BlackListedCDataRegex();
  $o_694->regex = '.';
  $o_694->error_message = 'contents';
  $o_693->blacklisted_cdata_regex[] = $o_694;
  $o_688->cdata = $o_693;
  $o_0->tags[] = $o_688;
  $o_695 = new TagSpec();
  $o_695->tag_name = 'amp-brightcove';
  $o_696 = new AttrSpec();
  $o_696->name = 'data-account';
  $o_696->mandatory = true;
  $o_695->attrs[] = $o_696;
  $o_697 = new AttrSpec();
  $o_697->name = 'data-embed';
  $o_695->attrs[] = $o_697;
  $o_698 = new AttrSpec();
  $o_698->name = 'data-player';
  $o_695->attrs[] = $o_698;
  $o_699 = new AttrSpec();
  $o_699->name = 'data-playlist-id';
  $o_695->attrs[] = $o_699;
  $o_700 = new AttrSpec();
  $o_700->name = 'data-video-id';
  $o_695->attrs[] = $o_700;
  $o_695->attr_lists = ['extended-amp-global'];
  $o_695->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-brightcove.html';
  $o_701 = new AmpLayout();
  $o_701->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_695->amp_layout = $o_701;
  $o_695->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_695->also_requires_tag = ['amp-brightcove extension .js script'];
  $o_0->tags[] = $o_695;
  $o_702 = new TagSpec();
  $o_702->tag_name = 'script';
  $o_702->spec_name = 'amp-carousel extension .js script';
  $o_702->mandatory_parent = 'head';
  $o_703 = new AttrSpec();
  $o_703->name = 'async';
  $o_703->mandatory = true;
  $o_703->value = '';
  $o_702->attrs[] = $o_703;
  $o_704 = new AttrSpec();
  $o_704->name = 'custom-element';
  $o_704->mandatory = true;
  $o_704->value = 'amp-carousel';
  $o_704->dispatch_key = true;
  $o_702->attrs[] = $o_704;
  $o_705 = new AttrSpec();
  $o_705->name = 'src';
  $o_705->mandatory = true;
  $o_705->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-carousel-(latest|0\\.1).js';
  $o_702->attrs[] = $o_705;
  $o_706 = new AttrSpec();
  $o_706->name = 'type';
  $o_706->value = 'text/javascript';
  $o_702->attrs[] = $o_706;
  $o_702->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-carousel.html';
  $o_707 = new CdataSpec();
  $o_708 = new BlackListedCDataRegex();
  $o_708->regex = '.';
  $o_708->error_message = 'contents';
  $o_707->blacklisted_cdata_regex[] = $o_708;
  $o_702->cdata = $o_707;
  $o_0->tags[] = $o_702;
  $o_709 = new TagSpec();
  $o_709->tag_name = 'amp-carousel';
  $o_710 = new AttrSpec();
  $o_710->name = 'arrows';
  $o_710->value = '';
  $o_709->attrs[] = $o_710;
  $o_711 = new AttrSpec();
  $o_711->name = 'autoplay';
  $o_711->value = '';
  $o_709->attrs[] = $o_711;
  $o_712 = new AttrSpec();
  $o_712->name = 'controls';
  $o_709->attrs[] = $o_712;
  $o_713 = new AttrSpec();
  $o_713->name = 'delay';
  $o_713->value_regex = '[0-9]+';
  $o_709->attrs[] = $o_713;
  $o_714 = new AttrSpec();
  $o_714->name = 'dots';
  $o_714->value = '';
  $o_709->attrs[] = $o_714;
  $o_715 = new AttrSpec();
  $o_715->name = 'loop';
  $o_715->value = '';
  $o_709->attrs[] = $o_715;
  $o_716 = new AttrSpec();
  $o_716->name = 'type';
  $o_716->value_regex = 'slides|carousel';
  $o_709->attrs[] = $o_716;
  $o_709->attr_lists = ['extended-amp-global'];
  $o_709->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-carousel.html';
  $o_717 = new AmpLayout();
  $o_717->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_709->amp_layout = $o_717;
  $o_709->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_709->also_requires_tag = ['amp-carousel extension .js script'];
  $o_0->tags[] = $o_709;
  $o_718 = new TagSpec();
  $o_718->tag_name = 'script';
  $o_718->spec_name = 'amp-dailymotion extension .js script';
  $o_718->mandatory_parent = 'head';
  $o_719 = new AttrSpec();
  $o_719->name = 'async';
  $o_719->mandatory = true;
  $o_719->value = '';
  $o_718->attrs[] = $o_719;
  $o_720 = new AttrSpec();
  $o_720->name = 'custom-element';
  $o_720->mandatory = true;
  $o_720->value = 'amp-dailymotion';
  $o_720->dispatch_key = true;
  $o_718->attrs[] = $o_720;
  $o_721 = new AttrSpec();
  $o_721->name = 'src';
  $o_721->mandatory = true;
  $o_721->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-dailymotion-(latest|0\\.1)\\.js';
  $o_718->attrs[] = $o_721;
  $o_722 = new AttrSpec();
  $o_722->name = 'type';
  $o_722->value = 'text/javascript';
  $o_718->attrs[] = $o_722;
  $o_718->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-dailymotion.html';
  $o_723 = new CdataSpec();
  $o_724 = new BlackListedCDataRegex();
  $o_724->regex = '.';
  $o_724->error_message = 'contents';
  $o_723->blacklisted_cdata_regex[] = $o_724;
  $o_718->cdata = $o_723;
  $o_0->tags[] = $o_718;
  $o_725 = new TagSpec();
  $o_725->tag_name = 'amp-dailymotion';
  $o_726 = new AttrSpec();
  $o_726->name = 'data-endscreen-enable';
  $o_726->value_regex = 'true|false';
  $o_725->attrs[] = $o_726;
  $o_727 = new AttrSpec();
  $o_727->name = 'data-info';
  $o_727->value_regex = 'true|false';
  $o_725->attrs[] = $o_727;
  $o_728 = new AttrSpec();
  $o_728->name = 'data-mute';
  $o_728->value_regex = 'true|false';
  $o_725->attrs[] = $o_728;
  $o_729 = new AttrSpec();
  $o_729->name = 'data-sharing-enable';
  $o_729->value_regex = 'true|false';
  $o_725->attrs[] = $o_729;
  $o_730 = new AttrSpec();
  $o_730->name = 'data-start';
  $o_730->value_regex = '[0-9]+';
  $o_725->attrs[] = $o_730;
  $o_731 = new AttrSpec();
  $o_731->name = 'data-ui-highlight';
  $o_731->value_regex_casei = '([0-9a-f]{3}){1,2}';
  $o_725->attrs[] = $o_731;
  $o_732 = new AttrSpec();
  $o_732->name = 'data-ui-logo';
  $o_732->value_regex = 'true|false';
  $o_725->attrs[] = $o_732;
  $o_733 = new AttrSpec();
  $o_733->name = 'data-videoid';
  $o_733->mandatory = true;
  $o_733->value_regex_casei = '[a-z0-9]+';
  $o_725->attrs[] = $o_733;
  $o_725->attr_lists = ['extended-amp-global'];
  $o_725->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-dailymotion.html';
  $o_734 = new AmpLayout();
  $o_734->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::RESPONSIVE];
  $o_725->amp_layout = $o_734;
  $o_725->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_725->also_requires_tag = ['amp-dailymotion extension .js script'];
  $o_0->tags[] = $o_725;
  $o_735 = new TagSpec();
  $o_735->tag_name = 'script';
  $o_735->spec_name = 'amp-dynamic-css-classes extension .js script';
  $o_735->mandatory_parent = 'head';
  $o_736 = new AttrSpec();
  $o_736->name = 'async';
  $o_736->mandatory = true;
  $o_736->value = '';
  $o_735->attrs[] = $o_736;
  $o_737 = new AttrSpec();
  $o_737->name = 'custom-element';
  $o_737->mandatory = true;
  $o_737->value = 'amp-dynamic-css-classes';
  $o_737->dispatch_key = true;
  $o_735->attrs[] = $o_737;
  $o_738 = new AttrSpec();
  $o_738->name = 'src';
  $o_738->mandatory = true;
  $o_738->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-dynamic-css-classes-(latest|0\\.1).js';
  $o_735->attrs[] = $o_738;
  $o_739 = new AttrSpec();
  $o_739->name = 'type';
  $o_739->value = 'text/javascript';
  $o_735->attrs[] = $o_739;
  $o_735->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-dynamic-css-classes.html';
  $o_740 = new CdataSpec();
  $o_741 = new BlackListedCDataRegex();
  $o_741->regex = '.';
  $o_741->error_message = 'contents';
  $o_740->blacklisted_cdata_regex[] = $o_741;
  $o_735->cdata = $o_740;
  $o_0->tags[] = $o_735;
  $o_742 = new TagSpec();
  $o_742->tag_name = 'script';
  $o_742->spec_name = 'amp-facebook extension .js script';
  $o_742->mandatory_parent = 'head';
  $o_743 = new AttrSpec();
  $o_743->name = 'async';
  $o_743->mandatory = true;
  $o_743->value = '';
  $o_742->attrs[] = $o_743;
  $o_744 = new AttrSpec();
  $o_744->name = 'custom-element';
  $o_744->mandatory = true;
  $o_744->value = 'amp-facebook';
  $o_744->dispatch_key = true;
  $o_742->attrs[] = $o_744;
  $o_745 = new AttrSpec();
  $o_745->name = 'src';
  $o_745->mandatory = true;
  $o_745->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-facebook-(latest|0\\.1).js';
  $o_742->attrs[] = $o_745;
  $o_746 = new AttrSpec();
  $o_746->name = 'type';
  $o_746->value = 'text/javascript';
  $o_742->attrs[] = $o_746;
  $o_742->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-facebook.html';
  $o_747 = new CdataSpec();
  $o_748 = new BlackListedCDataRegex();
  $o_748->regex = '.';
  $o_748->error_message = 'contents';
  $o_747->blacklisted_cdata_regex[] = $o_748;
  $o_742->cdata = $o_747;
  $o_0->tags[] = $o_742;
  $o_749 = new TagSpec();
  $o_749->tag_name = 'amp-facebook';
  $o_750 = new AttrSpec();
  $o_750->name = 'data-href';
  $o_750->mandatory = true;
  $o_749->attrs[] = $o_750;
  $o_749->attr_lists = ['extended-amp-global'];
  $o_749->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-facebook.html';
  $o_751 = new AmpLayout();
  $o_751->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_749->amp_layout = $o_751;
  $o_749->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_749->also_requires_tag = ['amp-facebook extension .js script'];
  $o_0->tags[] = $o_749;
  $o_752 = new TagSpec();
  $o_752->tag_name = 'script';
  $o_752->spec_name = 'amp-fit-text extension .js script';
  $o_752->mandatory_parent = 'head';
  $o_753 = new AttrSpec();
  $o_753->name = 'async';
  $o_753->mandatory = true;
  $o_753->value = '';
  $o_752->attrs[] = $o_753;
  $o_754 = new AttrSpec();
  $o_754->name = 'custom-element';
  $o_754->mandatory = true;
  $o_754->value = 'amp-fit-text';
  $o_754->dispatch_key = true;
  $o_752->attrs[] = $o_754;
  $o_755 = new AttrSpec();
  $o_755->name = 'src';
  $o_755->mandatory = true;
  $o_755->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-fit-text-(latest|0\\.1).js';
  $o_752->attrs[] = $o_755;
  $o_756 = new AttrSpec();
  $o_756->name = 'type';
  $o_756->value = 'text/javascript';
  $o_752->attrs[] = $o_756;
  $o_752->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-fit-text.html';
  $o_757 = new CdataSpec();
  $o_758 = new BlackListedCDataRegex();
  $o_758->regex = '.';
  $o_758->error_message = 'contents';
  $o_757->blacklisted_cdata_regex[] = $o_758;
  $o_752->cdata = $o_757;
  $o_0->tags[] = $o_752;
  $o_759 = new TagSpec();
  $o_759->tag_name = 'amp-fit-text';
  $o_760 = new AttrSpec();
  $o_760->name = 'max-font-size';
  $o_759->attrs[] = $o_760;
  $o_761 = new AttrSpec();
  $o_761->name = 'min-font-size';
  $o_759->attrs[] = $o_761;
  $o_759->attr_lists = ['extended-amp-global'];
  $o_759->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-fit-text.html';
  $o_762 = new AmpLayout();
  $o_762->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_759->amp_layout = $o_762;
  $o_759->disallowed_ancestor = ['head'];
  $o_759->also_requires_tag = ['amp-fit-text extension .js script'];
  $o_0->tags[] = $o_759;
  $o_763 = new TagSpec();
  $o_763->tag_name = 'script';
  $o_763->spec_name = 'amp-font extension .js script';
  $o_763->mandatory_parent = 'head';
  $o_764 = new AttrSpec();
  $o_764->name = 'async';
  $o_764->mandatory = true;
  $o_764->value = '';
  $o_763->attrs[] = $o_764;
  $o_765 = new AttrSpec();
  $o_765->name = 'custom-element';
  $o_765->mandatory = true;
  $o_765->value = 'amp-font';
  $o_765->dispatch_key = true;
  $o_763->attrs[] = $o_765;
  $o_766 = new AttrSpec();
  $o_766->name = 'src';
  $o_766->mandatory = true;
  $o_766->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-font-(latest|0\\.1).js';
  $o_763->attrs[] = $o_766;
  $o_767 = new AttrSpec();
  $o_767->name = 'type';
  $o_767->value = 'text/javascript';
  $o_763->attrs[] = $o_767;
  $o_763->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-font.html';
  $o_768 = new CdataSpec();
  $o_769 = new BlackListedCDataRegex();
  $o_769->regex = '.';
  $o_769->error_message = 'contents';
  $o_768->blacklisted_cdata_regex[] = $o_769;
  $o_763->cdata = $o_768;
  $o_0->tags[] = $o_763;
  $o_770 = new TagSpec();
  $o_770->tag_name = 'amp-font';
  $o_771 = new AttrSpec();
  $o_771->name = 'font-family';
  $o_771->mandatory = true;
  $o_770->attrs[] = $o_771;
  $o_772 = new AttrSpec();
  $o_772->name = 'font-style';
  $o_770->attrs[] = $o_772;
  $o_773 = new AttrSpec();
  $o_773->name = 'font-variant';
  $o_770->attrs[] = $o_773;
  $o_774 = new AttrSpec();
  $o_774->name = 'timeout';
  $o_774->value_regex = '[0-9]+';
  $o_770->attrs[] = $o_774;
  $o_775 = new AttrSpec();
  $o_775->name = 'font-weight';
  $o_770->attrs[] = $o_775;
  $o_776 = new AttrSpec();
  $o_776->name = 'on-error-add-class';
  $o_770->attrs[] = $o_776;
  $o_777 = new AttrSpec();
  $o_777->name = 'on-error-remove-class';
  $o_770->attrs[] = $o_777;
  $o_778 = new AttrSpec();
  $o_778->name = 'on-load-add-class';
  $o_770->attrs[] = $o_778;
  $o_779 = new AttrSpec();
  $o_779->name = 'on-load-remove-class';
  $o_770->attrs[] = $o_779;
  $o_770->attr_lists = ['extended-amp-global'];
  $o_770->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-font.html';
  $o_780 = new AmpLayout();
  $o_780->supported_layouts = [AmpLayoutLayout::NODISPLAY];
  $o_770->amp_layout = $o_780;
  $o_770->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_770->also_requires_tag = ['amp-font extension .js script'];
  $o_0->tags[] = $o_770;
  $o_781 = new TagSpec();
  $o_781->tag_name = 'script';
  $o_781->spec_name = 'amp-iframe extension .js script';
  $o_781->mandatory_parent = 'head';
  $o_782 = new AttrSpec();
  $o_782->name = 'async';
  $o_782->mandatory = true;
  $o_782->value = '';
  $o_781->attrs[] = $o_782;
  $o_783 = new AttrSpec();
  $o_783->name = 'custom-element';
  $o_783->mandatory = true;
  $o_783->value = 'amp-iframe';
  $o_783->dispatch_key = true;
  $o_781->attrs[] = $o_783;
  $o_784 = new AttrSpec();
  $o_784->name = 'src';
  $o_784->mandatory = true;
  $o_784->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-iframe-(latest|0\\.1).js';
  $o_781->attrs[] = $o_784;
  $o_785 = new AttrSpec();
  $o_785->name = 'type';
  $o_785->value = 'text/javascript';
  $o_781->attrs[] = $o_785;
  $o_781->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-iframe.html';
  $o_786 = new CdataSpec();
  $o_787 = new BlackListedCDataRegex();
  $o_787->regex = '.';
  $o_787->error_message = 'contents';
  $o_786->blacklisted_cdata_regex[] = $o_787;
  $o_781->cdata = $o_786;
  $o_0->tags[] = $o_781;
  $o_788 = new TagSpec();
  $o_788->tag_name = 'amp-iframe';
  $o_789 = new AttrSpec();
  $o_789->name = 'allowfullscreen';
  $o_789->value = '';
  $o_788->attrs[] = $o_789;
  $o_790 = new AttrSpec();
  $o_790->name = 'allowtransparency';
  $o_790->value = '';
  $o_788->attrs[] = $o_790;
  $o_791 = new AttrSpec();
  $o_791->name = 'frameborder';
  $o_791->value_regex = '0|1';
  $o_788->attrs[] = $o_791;
  $o_792 = new AttrSpec();
  $o_792->name = 'resizable';
  $o_792->value = '';
  $o_788->attrs[] = $o_792;
  $o_793 = new AttrSpec();
  $o_793->name = 'sandbox';
  $o_788->attrs[] = $o_793;
  $o_794 = new AttrSpec();
  $o_794->name = 'scrolling';
  $o_794->value_regex = 'auto|yes|no';
  $o_788->attrs[] = $o_794;
  $o_795 = new AttrSpec();
  $o_795->name = 'src';
  $o_795->mandatory_oneof = '[\'src\', \'srcdoc\']';
  $o_796 = new UrlSpec();
  $o_796->allowed_protocol = ['data', 'https'];
  $o_796->allow_relative = true;
  $o_795->value_url = $o_796;
  $o_788->attrs[] = $o_795;
  $o_797 = new AttrSpec();
  $o_797->name = 'srcdoc';
  $o_797->mandatory_oneof = '[\'src\', \'srcdoc\']';
  $o_788->attrs[] = $o_797;
  $o_788->attr_lists = ['extended-amp-global'];
  $o_788->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-iframe.html';
  $o_798 = new AmpLayout();
  $o_798->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_788->amp_layout = $o_798;
  $o_788->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_788->also_requires_tag = ['amp-iframe extension .js script'];
  $o_0->tags[] = $o_788;
  $o_799 = new TagSpec();
  $o_799->tag_name = 'script';
  $o_799->spec_name = 'amp-image-lightbox extension .js script';
  $o_799->mandatory_parent = 'head';
  $o_800 = new AttrSpec();
  $o_800->name = 'async';
  $o_800->mandatory = true;
  $o_800->value = '';
  $o_799->attrs[] = $o_800;
  $o_801 = new AttrSpec();
  $o_801->name = 'custom-element';
  $o_801->mandatory = true;
  $o_801->value = 'amp-image-lightbox';
  $o_801->dispatch_key = true;
  $o_799->attrs[] = $o_801;
  $o_802 = new AttrSpec();
  $o_802->name = 'src';
  $o_802->mandatory = true;
  $o_802->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-image-lightbox-(latest|0\\.1).js';
  $o_799->attrs[] = $o_802;
  $o_803 = new AttrSpec();
  $o_803->name = 'type';
  $o_803->value = 'text/javascript';
  $o_799->attrs[] = $o_803;
  $o_799->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-image-lightbox.html';
  $o_804 = new CdataSpec();
  $o_805 = new BlackListedCDataRegex();
  $o_805->regex = '.';
  $o_805->error_message = 'contents';
  $o_804->blacklisted_cdata_regex[] = $o_805;
  $o_799->cdata = $o_804;
  $o_0->tags[] = $o_799;
  $o_806 = new TagSpec();
  $o_806->tag_name = 'amp-image-lightbox';
  $o_807 = new AttrSpec();
  $o_807->name = 'controls';
  $o_806->attrs[] = $o_807;
  $o_806->attr_lists = ['extended-amp-global'];
  $o_806->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-image-lightbox.html';
  $o_808 = new AmpLayout();
  $o_808->supported_layouts = [AmpLayoutLayout::NODISPLAY];
  $o_806->amp_layout = $o_808;
  $o_806->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_806->also_requires_tag = ['amp-image-lightbox extension .js script'];
  $o_0->tags[] = $o_806;
  $o_809 = new TagSpec();
  $o_809->tag_name = 'script';
  $o_809->spec_name = 'amp-instagram extension .js script';
  $o_809->mandatory_parent = 'head';
  $o_810 = new AttrSpec();
  $o_810->name = 'async';
  $o_810->mandatory = true;
  $o_810->value = '';
  $o_809->attrs[] = $o_810;
  $o_811 = new AttrSpec();
  $o_811->name = 'custom-element';
  $o_811->mandatory = true;
  $o_811->value = 'amp-instagram';
  $o_811->dispatch_key = true;
  $o_809->attrs[] = $o_811;
  $o_812 = new AttrSpec();
  $o_812->name = 'src';
  $o_812->mandatory = true;
  $o_812->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-instagram-(latest|0\\.1).js';
  $o_809->attrs[] = $o_812;
  $o_813 = new AttrSpec();
  $o_813->name = 'type';
  $o_813->value = 'text/javascript';
  $o_809->attrs[] = $o_813;
  $o_809->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-instagram.html';
  $o_814 = new CdataSpec();
  $o_815 = new BlackListedCDataRegex();
  $o_815->regex = '.';
  $o_815->error_message = 'contents';
  $o_814->blacklisted_cdata_regex[] = $o_815;
  $o_809->cdata = $o_814;
  $o_0->tags[] = $o_809;
  $o_816 = new TagSpec();
  $o_816->tag_name = 'amp-instagram';
  $o_817 = new AttrSpec();
  $o_817->name = 'alt';
  $o_816->attrs[] = $o_817;
  $o_818 = new AttrSpec();
  $o_818->name = 'data-shortcode';
  $o_818->mandatory_oneof = '[\'data-shortcode\', \'src\']';
  $o_816->attrs[] = $o_818;
  $o_819 = new AttrSpec();
  $o_819->name = 'shortcode';
  $o_819->deprecation = 'data-shortcode';
  $o_819->deprecation_url = 'https://www.ampproject.org/docs/reference/extended/amp-instagram.html';
  $o_819->mandatory_oneof = '[\'data-shortcode\', \'src\']';
  $o_816->attrs[] = $o_819;
  $o_820 = new AttrSpec();
  $o_820->name = 'src';
  $o_820->mandatory_oneof = '[\'data-shortcode\', \'src\']';
  $o_821 = new UrlSpec();
  $o_821->allowed_protocol = ['http', 'https'];
  $o_821->allow_relative = true;
  $o_820->value_url = $o_821;
  $o_816->attrs[] = $o_820;
  $o_816->attr_lists = ['extended-amp-global'];
  $o_816->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-instagram.html';
  $o_822 = new AmpLayout();
  $o_822->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_816->amp_layout = $o_822;
  $o_816->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_816->also_requires_tag = ['amp-instagram extension .js script'];
  $o_0->tags[] = $o_816;
  $o_823 = new TagSpec();
  $o_823->tag_name = 'script';
  $o_823->spec_name = 'amp-install-serviceworker extension .js script';
  $o_823->mandatory_parent = 'head';
  $o_824 = new AttrSpec();
  $o_824->name = 'async';
  $o_824->mandatory = true;
  $o_824->value = '';
  $o_823->attrs[] = $o_824;
  $o_825 = new AttrSpec();
  $o_825->name = 'custom-element';
  $o_825->mandatory = true;
  $o_825->value = 'amp-install-serviceworker';
  $o_825->dispatch_key = true;
  $o_823->attrs[] = $o_825;
  $o_826 = new AttrSpec();
  $o_826->name = 'src';
  $o_826->mandatory = true;
  $o_826->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-install-serviceworker-(latest|0\\.1).js';
  $o_823->attrs[] = $o_826;
  $o_827 = new AttrSpec();
  $o_827->name = 'type';
  $o_827->value = 'text/javascript';
  $o_823->attrs[] = $o_827;
  $o_823->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-install-serviceworker.html';
  $o_828 = new CdataSpec();
  $o_829 = new BlackListedCDataRegex();
  $o_829->regex = '.';
  $o_829->error_message = 'contents';
  $o_828->blacklisted_cdata_regex[] = $o_829;
  $o_823->cdata = $o_828;
  $o_0->tags[] = $o_823;
  $o_830 = new TagSpec();
  $o_830->tag_name = 'amp-install-serviceworker';
  $o_831 = new AttrSpec();
  $o_831->name = 'src';
  $o_831->mandatory = true;
  $o_832 = new UrlSpec();
  $o_832->allowed_protocol = ['https'];
  $o_832->allow_relative = true;
  $o_831->value_url = $o_832;
  $o_830->attrs[] = $o_831;
  $o_830->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-install-serviceworker.html';
  $o_833 = new AmpLayout();
  $o_833->supported_layouts = [AmpLayoutLayout::NODISPLAY];
  $o_830->amp_layout = $o_833;
  $o_830->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_830->also_requires_tag = ['amp-install-serviceworker extension .js script'];
  $o_0->tags[] = $o_830;
  $o_834 = new TagSpec();
  $o_834->tag_name = 'script';
  $o_834->spec_name = 'amp-jwplayer extension .js script';
  $o_834->mandatory_parent = 'head';
  $o_835 = new AttrSpec();
  $o_835->name = 'async';
  $o_835->mandatory = true;
  $o_835->value = '';
  $o_834->attrs[] = $o_835;
  $o_836 = new AttrSpec();
  $o_836->name = 'custom-element';
  $o_836->mandatory = true;
  $o_836->value = 'amp-jwplayer';
  $o_836->dispatch_key = true;
  $o_834->attrs[] = $o_836;
  $o_837 = new AttrSpec();
  $o_837->name = 'src';
  $o_837->mandatory = true;
  $o_837->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-jwplayer-(latest|0\\.1).js';
  $o_834->attrs[] = $o_837;
  $o_838 = new AttrSpec();
  $o_838->name = 'type';
  $o_838->value = 'text/javascript';
  $o_834->attrs[] = $o_838;
  $o_834->spec_url = 'https://github.com/ampproject/amphtml/blob/master/extensions/amp-jwplayer/amp-jwplayer.md';
  $o_839 = new CdataSpec();
  $o_840 = new BlackListedCDataRegex();
  $o_840->regex = '.';
  $o_840->error_message = 'contents';
  $o_839->blacklisted_cdata_regex[] = $o_840;
  $o_834->cdata = $o_839;
  $o_0->tags[] = $o_834;
  $o_841 = new TagSpec();
  $o_841->tag_name = 'amp-jwplayer';
  $o_842 = new AttrSpec();
  $o_842->name = 'data-media-id';
  $o_842->value_regex_casei = '[0-9a-z]{8}';
  $o_842->mandatory_oneof = 'data-media-id or data-playlist-id';
  $o_841->attrs[] = $o_842;
  $o_843 = new AttrSpec();
  $o_843->name = 'data-player-id';
  $o_843->mandatory = true;
  $o_843->value_regex_casei = '[0-9a-z]{8}';
  $o_841->attrs[] = $o_843;
  $o_844 = new AttrSpec();
  $o_844->name = 'data-playlist-id';
  $o_844->value_regex_casei = '[0-9a-z]{8}';
  $o_844->mandatory_oneof = 'data-media-id or data-playlist-id';
  $o_841->attrs[] = $o_844;
  $o_841->spec_url = 'https://github.com/ampproject/amphtml/blob/master/extensions/amp-jwplayer/amp-jwplayer.md';
  $o_845 = new AmpLayout();
  $o_845->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_841->amp_layout = $o_845;
  $o_841->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_841->also_requires_tag = ['amp-jwplayer extension .js script'];
  $o_0->tags[] = $o_841;
  $o_846 = new TagSpec();
  $o_846->tag_name = 'script';
  $o_846->spec_name = 'amp-kaltura-player extension .js script';
  $o_846->mandatory_parent = 'head';
  $o_847 = new AttrSpec();
  $o_847->name = 'async';
  $o_847->mandatory = true;
  $o_847->value = '';
  $o_846->attrs[] = $o_847;
  $o_848 = new AttrSpec();
  $o_848->name = 'custom-element';
  $o_848->mandatory = true;
  $o_848->value = 'amp-kaltura-player';
  $o_848->dispatch_key = true;
  $o_846->attrs[] = $o_848;
  $o_849 = new AttrSpec();
  $o_849->name = 'src';
  $o_849->mandatory = true;
  $o_849->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-kaltura-player-(latest|0\\.1)\\.js';
  $o_846->attrs[] = $o_849;
  $o_850 = new AttrSpec();
  $o_850->name = 'type';
  $o_850->value = 'text/javascript';
  $o_846->attrs[] = $o_850;
  $o_846->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-kaltura-player.html';
  $o_851 = new CdataSpec();
  $o_852 = new BlackListedCDataRegex();
  $o_852->regex = '.';
  $o_852->error_message = 'contents';
  $o_851->blacklisted_cdata_regex[] = $o_852;
  $o_846->cdata = $o_851;
  $o_0->tags[] = $o_846;
  $o_853 = new TagSpec();
  $o_853->tag_name = 'amp-kaltura-player';
  $o_854 = new AttrSpec();
  $o_854->name = 'data-partner';
  $o_854->mandatory = true;
  $o_853->attrs[] = $o_854;
  $o_853->attr_lists = ['extended-amp-global'];
  $o_853->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-kaltura-player.html';
  $o_855 = new AmpLayout();
  $o_855->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_853->amp_layout = $o_855;
  $o_853->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_853->also_requires_tag = ['amp-kaltura-player extension .js script'];
  $o_0->tags[] = $o_853;
  $o_856 = new TagSpec();
  $o_856->tag_name = 'script';
  $o_856->spec_name = 'amp-lightbox extension .js script';
  $o_856->mandatory_parent = 'head';
  $o_857 = new AttrSpec();
  $o_857->name = 'async';
  $o_857->mandatory = true;
  $o_857->value = '';
  $o_856->attrs[] = $o_857;
  $o_858 = new AttrSpec();
  $o_858->name = 'custom-element';
  $o_858->mandatory = true;
  $o_858->value = 'amp-lightbox';
  $o_858->dispatch_key = true;
  $o_856->attrs[] = $o_858;
  $o_859 = new AttrSpec();
  $o_859->name = 'src';
  $o_859->mandatory = true;
  $o_859->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-lightbox-(latest|0\\.1).js';
  $o_856->attrs[] = $o_859;
  $o_860 = new AttrSpec();
  $o_860->name = 'type';
  $o_860->value = 'text/javascript';
  $o_856->attrs[] = $o_860;
  $o_856->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-lightbox.html';
  $o_861 = new CdataSpec();
  $o_862 = new BlackListedCDataRegex();
  $o_862->regex = '.';
  $o_862->error_message = 'contents';
  $o_861->blacklisted_cdata_regex[] = $o_862;
  $o_856->cdata = $o_861;
  $o_0->tags[] = $o_856;
  $o_863 = new TagSpec();
  $o_863->tag_name = 'amp-lightbox';
  $o_864 = new AttrSpec();
  $o_864->name = 'controls';
  $o_863->attrs[] = $o_864;
  $o_865 = new AttrSpec();
  $o_865->name = 'from';
  $o_863->attrs[] = $o_865;
  $o_863->attr_lists = ['extended-amp-global'];
  $o_863->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-lightbox.html';
  $o_866 = new AmpLayout();
  $o_866->supported_layouts = [AmpLayoutLayout::NODISPLAY];
  $o_863->amp_layout = $o_866;
  $o_863->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_863->also_requires_tag = ['amp-lightbox extension .js script'];
  $o_0->tags[] = $o_863;
  $o_867 = new TagSpec();
  $o_867->tag_name = 'script';
  $o_867->spec_name = 'amp-list extension .js script';
  $o_867->mandatory_parent = 'head';
  $o_868 = new AttrSpec();
  $o_868->name = 'async';
  $o_868->mandatory = true;
  $o_868->value = '';
  $o_867->attrs[] = $o_868;
  $o_869 = new AttrSpec();
  $o_869->name = 'custom-element';
  $o_869->mandatory = true;
  $o_869->value = 'amp-list';
  $o_869->dispatch_key = true;
  $o_867->attrs[] = $o_869;
  $o_870 = new AttrSpec();
  $o_870->name = 'src';
  $o_870->mandatory = true;
  $o_870->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-list-(latest|0\\.1).js';
  $o_867->attrs[] = $o_870;
  $o_871 = new AttrSpec();
  $o_871->name = 'type';
  $o_871->value = 'text/javascript';
  $o_867->attrs[] = $o_871;
  $o_867->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-list.html';
  $o_872 = new CdataSpec();
  $o_873 = new BlackListedCDataRegex();
  $o_873->regex = '.';
  $o_873->error_message = 'contents';
  $o_872->blacklisted_cdata_regex[] = $o_873;
  $o_867->cdata = $o_872;
  $o_0->tags[] = $o_867;
  $o_874 = new TagSpec();
  $o_874->tag_name = 'amp-list';
  $o_875 = new AttrSpec();
  $o_875->name = 'credentials';
  $o_874->attrs[] = $o_875;
  $o_876 = new AttrSpec();
  $o_876->name = 'src';
  $o_876->mandatory = true;
  $o_877 = new UrlSpec();
  $o_877->allowed_protocol = ['https'];
  $o_877->allow_relative = true;
  $o_876->value_url = $o_877;
  $o_874->attrs[] = $o_876;
  $o_878 = new AttrSpec();
  $o_878->name = 'template';
  $o_874->attrs[] = $o_878;
  $o_874->attr_lists = ['extended-amp-global'];
  $o_874->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-list.html';
  $o_879 = new AmpLayout();
  $o_879->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_874->amp_layout = $o_879;
  $o_874->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_874->also_requires_tag = ['amp-list extension .js script'];
  $o_0->tags[] = $o_874;
  $o_880 = new TagSpec();
  $o_880->tag_name = 'script';
  $o_880->spec_name = 'amp-mustache extension .js script';
  $o_880->mandatory_parent = 'head';
  $o_881 = new AttrSpec();
  $o_881->name = 'async';
  $o_881->mandatory = true;
  $o_881->value = '';
  $o_880->attrs[] = $o_881;
  $o_882 = new AttrSpec();
  $o_882->name = 'custom-template';
  $o_882->mandatory = true;
  $o_882->value = 'amp-mustache';
  $o_882->dispatch_key = true;
  $o_880->attrs[] = $o_882;
  $o_883 = new AttrSpec();
  $o_883->name = 'src';
  $o_883->mandatory = true;
  $o_883->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-mustache-(latest|0\\.1).js';
  $o_880->attrs[] = $o_883;
  $o_884 = new AttrSpec();
  $o_884->name = 'type';
  $o_884->value = 'text/javascript';
  $o_880->attrs[] = $o_884;
  $o_880->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-mustache.html';
  $o_885 = new CdataSpec();
  $o_886 = new BlackListedCDataRegex();
  $o_886->regex = '.';
  $o_886->error_message = 'contents';
  $o_885->blacklisted_cdata_regex[] = $o_886;
  $o_880->cdata = $o_885;
  $o_0->tags[] = $o_880;
  $o_887 = new TagSpec();
  $o_887->tag_name = 'template';
  $o_888 = new AttrSpec();
  $o_888->name = 'type';
  $o_888->mandatory = true;
  $o_888->value = 'amp-mustache';
  $o_887->attrs[] = $o_888;
  $o_887->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-mustache.html';
  $o_887->disallowed_ancestor = ['template'];
  $o_887->also_requires_tag = ['amp-mustache extension .js script'];
  $o_0->tags[] = $o_887;
  $o_889 = new TagSpec();
  $o_889->tag_name = 'script';
  $o_889->spec_name = 'amp-pinterest extension .js script';
  $o_889->mandatory_parent = 'head';
  $o_890 = new AttrSpec();
  $o_890->name = 'async';
  $o_890->mandatory = true;
  $o_890->value = '';
  $o_889->attrs[] = $o_890;
  $o_891 = new AttrSpec();
  $o_891->name = 'custom-element';
  $o_891->mandatory = true;
  $o_891->value = 'amp-pinterest';
  $o_891->dispatch_key = true;
  $o_889->attrs[] = $o_891;
  $o_892 = new AttrSpec();
  $o_892->name = 'src';
  $o_892->mandatory = true;
  $o_892->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-pinterest-(latest|0\\.1).js';
  $o_889->attrs[] = $o_892;
  $o_893 = new AttrSpec();
  $o_893->name = 'type';
  $o_893->value = 'text/javascript';
  $o_889->attrs[] = $o_893;
  $o_889->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-pinterest.html';
  $o_894 = new CdataSpec();
  $o_895 = new BlackListedCDataRegex();
  $o_895->regex = '.';
  $o_895->error_message = 'contents';
  $o_894->blacklisted_cdata_regex[] = $o_895;
  $o_889->cdata = $o_894;
  $o_0->tags[] = $o_889;
  $o_896 = new TagSpec();
  $o_896->tag_name = 'amp-pinterest';
  $o_897 = new AttrSpec();
  $o_897->name = 'data-do';
  $o_897->mandatory = true;
  $o_896->attrs[] = $o_897;
  $o_896->attr_lists = ['extended-amp-global'];
  $o_896->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-pinterest.html';
  $o_898 = new AmpLayout();
  $o_898->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_896->amp_layout = $o_898;
  $o_896->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_896->also_requires_tag = ['amp-pinterest extension .js script'];
  $o_0->tags[] = $o_896;
  $o_899 = new TagSpec();
  $o_899->tag_name = 'script';
  $o_899->spec_name = 'amp-reach-player extension .js script';
  $o_899->mandatory_parent = 'head';
  $o_900 = new AttrSpec();
  $o_900->name = 'async';
  $o_900->mandatory = true;
  $o_900->value = '';
  $o_899->attrs[] = $o_900;
  $o_901 = new AttrSpec();
  $o_901->name = 'custom-element';
  $o_901->mandatory = true;
  $o_901->value = 'amp-reach-player';
  $o_901->dispatch_key = true;
  $o_899->attrs[] = $o_901;
  $o_902 = new AttrSpec();
  $o_902->name = 'src';
  $o_902->mandatory = true;
  $o_902->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-reach-player-(latest|0\\.1).js';
  $o_899->attrs[] = $o_902;
  $o_903 = new AttrSpec();
  $o_903->name = 'type';
  $o_903->value = 'text/javascript';
  $o_899->attrs[] = $o_903;
  $o_904 = new CdataSpec();
  $o_905 = new BlackListedCDataRegex();
  $o_905->regex = '.';
  $o_905->error_message = 'contents';
  $o_904->blacklisted_cdata_regex[] = $o_905;
  $o_899->cdata = $o_904;
  $o_0->tags[] = $o_899;
  $o_906 = new TagSpec();
  $o_906->tag_name = 'amp-reach-player';
  $o_907 = new AttrSpec();
  $o_907->name = 'data-embed-id';
  $o_907->mandatory = true;
  $o_907->value_regex = '[0-9a-z-]+';
  $o_906->attrs[] = $o_907;
  $o_906->attr_lists = ['extended-amp-global'];
  $o_908 = new AmpLayout();
  $o_908->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::RESPONSIVE];
  $o_906->amp_layout = $o_908;
  $o_906->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_906->also_requires_tag = ['amp-reach-player extension .js script'];
  $o_0->tags[] = $o_906;
  $o_909 = new TagSpec();
  $o_909->tag_name = 'script';
  $o_909->spec_name = 'amp-sidebar extension .js script';
  $o_909->mandatory_parent = 'head';
  $o_910 = new AttrSpec();
  $o_910->name = 'async';
  $o_910->mandatory = true;
  $o_910->value = '';
  $o_909->attrs[] = $o_910;
  $o_911 = new AttrSpec();
  $o_911->name = 'custom-element';
  $o_911->mandatory = true;
  $o_911->value = 'amp-sidebar';
  $o_911->dispatch_key = true;
  $o_909->attrs[] = $o_911;
  $o_912 = new AttrSpec();
  $o_912->name = 'src';
  $o_912->mandatory = true;
  $o_912->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-sidebar-(latest|0\\.1).js';
  $o_909->attrs[] = $o_912;
  $o_913 = new AttrSpec();
  $o_913->name = 'type';
  $o_913->value = 'text/javascript';
  $o_909->attrs[] = $o_913;
  $o_909->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-sidebar.html';
  $o_914 = new CdataSpec();
  $o_915 = new BlackListedCDataRegex();
  $o_915->regex = '.';
  $o_915->error_message = 'contents';
  $o_914->blacklisted_cdata_regex[] = $o_915;
  $o_909->cdata = $o_914;
  $o_0->tags[] = $o_909;
  $o_916 = new TagSpec();
  $o_916->tag_name = 'amp-sidebar';
  $o_916->unique = true;
  $o_916->mandatory_parent = 'body';
  $o_917 = new AttrSpec();
  $o_917->name = 'side';
  $o_917->value_regex = '(left|right)';
  $o_916->attrs[] = $o_917;
  $o_916->attr_lists = ['extended-amp-global'];
  $o_916->spec_url = 'https://github.com/ampproject/amphtml/blob/master/extensions/amp-sidebar/amp-sidebar.md';
  $o_918 = new AmpLayout();
  $o_918->supported_layouts = [AmpLayoutLayout::NODISPLAY];
  $o_916->amp_layout = $o_918;
  $o_916->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_916->also_requires_tag = ['amp-sidebar extension .js script'];
  $o_0->tags[] = $o_916;
  $o_919 = new TagSpec();
  $o_919->tag_name = 'script';
  $o_919->spec_name = 'amp-slides extension .js script';
  $o_919->mandatory_parent = 'head';
  $o_920 = new AttrSpec();
  $o_920->name = 'async';
  $o_920->mandatory = true;
  $o_920->value = '';
  $o_919->attrs[] = $o_920;
  $o_921 = new AttrSpec();
  $o_921->name = 'custom-element';
  $o_921->mandatory = true;
  $o_921->value = 'amp-slides';
  $o_921->dispatch_key = true;
  $o_919->attrs[] = $o_921;
  $o_922 = new AttrSpec();
  $o_922->name = 'src';
  $o_922->mandatory = true;
  $o_922->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-slides-(latest|0\\.1).js';
  $o_919->attrs[] = $o_922;
  $o_923 = new AttrSpec();
  $o_923->name = 'type';
  $o_923->value = 'text/javascript';
  $o_919->attrs[] = $o_923;
  $o_919->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-slides.html';
  $o_924 = new CdataSpec();
  $o_925 = new BlackListedCDataRegex();
  $o_925->regex = '.';
  $o_925->error_message = 'contents';
  $o_924->blacklisted_cdata_regex[] = $o_925;
  $o_919->cdata = $o_924;
  $o_0->tags[] = $o_919;
  $o_926 = new TagSpec();
  $o_926->tag_name = 'script';
  $o_926->spec_name = 'amp-social-share extension .js script';
  $o_926->mandatory_parent = 'head';
  $o_927 = new AttrSpec();
  $o_927->name = 'async';
  $o_927->mandatory = true;
  $o_927->value = '';
  $o_926->attrs[] = $o_927;
  $o_928 = new AttrSpec();
  $o_928->name = 'custom-element';
  $o_928->mandatory = true;
  $o_928->value = 'amp-social-share';
  $o_928->dispatch_key = true;
  $o_926->attrs[] = $o_928;
  $o_929 = new AttrSpec();
  $o_929->name = 'src';
  $o_929->mandatory = true;
  $o_929->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-social-share-(latest|0\\.1)\\.js';
  $o_926->attrs[] = $o_929;
  $o_930 = new AttrSpec();
  $o_930->name = 'type';
  $o_930->value = 'text/javascript';
  $o_926->attrs[] = $o_930;
  $o_926->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-social-share.html';
  $o_931 = new CdataSpec();
  $o_932 = new BlackListedCDataRegex();
  $o_932->regex = '.';
  $o_932->error_message = 'contents';
  $o_931->blacklisted_cdata_regex[] = $o_932;
  $o_926->cdata = $o_931;
  $o_0->tags[] = $o_926;
  $o_933 = new TagSpec();
  $o_933->tag_name = 'amp-social-share';
  $o_934 = new AttrSpec();
  $o_934->name = 'type';
  $o_934->mandatory = true;
  $o_933->attrs[] = $o_934;
  $o_935 = new AttrSpec();
  $o_935->name = 'data-share-endpoint';
  $o_936 = new UrlSpec();
  $o_936->allowed_protocol = ['ftp', 'http', 'https', 'mailto', 'fb-messenger', 'snapchat', 'sms', 'tel', 'viber', 'whatsapp'];
  $o_936->allow_relative = false;
  $o_935->value_url = $o_936;
  $o_933->attrs[] = $o_935;
  $o_933->attr_lists = ['extended-amp-global'];
  $o_933->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-social-share.html';
  $o_937 = new AmpLayout();
  $o_937->supported_layouts = [AmpLayoutLayout::CONTAINER, AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_933->amp_layout = $o_937;
  $o_933->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_933->also_requires_tag = ['amp-social-share extension .js script'];
  $o_0->tags[] = $o_933;
  $o_938 = new TagSpec();
  $o_938->tag_name = 'script';
  $o_938->spec_name = 'amp-soundcloud extension .js script';
  $o_938->mandatory_parent = 'head';
  $o_939 = new AttrSpec();
  $o_939->name = 'async';
  $o_939->mandatory = true;
  $o_939->value = '';
  $o_938->attrs[] = $o_939;
  $o_940 = new AttrSpec();
  $o_940->name = 'custom-element';
  $o_940->mandatory = true;
  $o_940->value = 'amp-soundcloud';
  $o_940->dispatch_key = true;
  $o_938->attrs[] = $o_940;
  $o_941 = new AttrSpec();
  $o_941->name = 'src';
  $o_941->mandatory = true;
  $o_941->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-soundcloud-(latest|0\\.1)\\.js';
  $o_938->attrs[] = $o_941;
  $o_942 = new AttrSpec();
  $o_942->name = 'type';
  $o_942->value = 'text/javascript';
  $o_938->attrs[] = $o_942;
  $o_938->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-soundcloud.html';
  $o_943 = new CdataSpec();
  $o_944 = new BlackListedCDataRegex();
  $o_944->regex = '.';
  $o_944->error_message = 'contents';
  $o_943->blacklisted_cdata_regex[] = $o_944;
  $o_938->cdata = $o_943;
  $o_0->tags[] = $o_938;
  $o_945 = new TagSpec();
  $o_945->tag_name = 'amp-soundcloud';
  $o_946 = new AttrSpec();
  $o_946->name = 'data-color';
  $o_946->value_regex_casei = '([0-9a-f]{3}){1,2}';
  $o_945->attrs[] = $o_946;
  $o_947 = new AttrSpec();
  $o_947->name = 'data-trackid';
  $o_947->mandatory = true;
  $o_947->value_regex = '[0-9]+';
  $o_945->attrs[] = $o_947;
  $o_948 = new AttrSpec();
  $o_948->name = 'data-visual';
  $o_948->value_regex = 'true|false';
  $o_945->attrs[] = $o_948;
  $o_945->attr_lists = ['extended-amp-global'];
  $o_945->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-soundcloud.html';
  $o_949 = new AmpLayout();
  $o_949->supported_layouts = [AmpLayoutLayout::FIXED_HEIGHT];
  $o_945->amp_layout = $o_949;
  $o_945->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_945->also_requires_tag = ['amp-soundcloud extension .js script'];
  $o_0->tags[] = $o_945;
  $o_950 = new TagSpec();
  $o_950->tag_name = 'script';
  $o_950->spec_name = 'amp-springboard-player extension .js script';
  $o_950->mandatory_parent = 'head';
  $o_951 = new AttrSpec();
  $o_951->name = 'async';
  $o_951->mandatory = true;
  $o_951->value = '';
  $o_950->attrs[] = $o_951;
  $o_952 = new AttrSpec();
  $o_952->name = 'custom-element';
  $o_952->mandatory = true;
  $o_952->value = 'amp-springboard-player';
  $o_952->dispatch_key = true;
  $o_950->attrs[] = $o_952;
  $o_953 = new AttrSpec();
  $o_953->name = 'src';
  $o_953->mandatory = true;
  $o_953->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-springboard-player-(latest|0\\.1)\\.js';
  $o_950->attrs[] = $o_953;
  $o_954 = new AttrSpec();
  $o_954->name = 'type';
  $o_954->value = 'text/javascript';
  $o_950->attrs[] = $o_954;
  $o_950->spec_url = 'https://github.com/ampproject/amphtml/blob/master/extensions/amp-springboard-player/amp-springboard-player.html';
  $o_955 = new CdataSpec();
  $o_956 = new BlackListedCDataRegex();
  $o_956->regex = '.';
  $o_956->error_message = 'contents';
  $o_955->blacklisted_cdata_regex[] = $o_956;
  $o_950->cdata = $o_955;
  $o_0->tags[] = $o_950;
  $o_957 = new TagSpec();
  $o_957->tag_name = 'amp-springboard-player';
  $o_958 = new AttrSpec();
  $o_958->name = 'data-content-id';
  $o_958->mandatory = true;
  $o_957->attrs[] = $o_958;
  $o_959 = new AttrSpec();
  $o_959->name = 'data-domain';
  $o_959->mandatory = true;
  $o_957->attrs[] = $o_959;
  $o_960 = new AttrSpec();
  $o_960->name = 'data-items';
  $o_960->mandatory = true;
  $o_957->attrs[] = $o_960;
  $o_961 = new AttrSpec();
  $o_961->name = 'data-mode';
  $o_961->mandatory = true;
  $o_961->value_regex_casei = 'playlist|video';
  $o_957->attrs[] = $o_961;
  $o_962 = new AttrSpec();
  $o_962->name = 'data-player-id';
  $o_962->mandatory = true;
  $o_962->value_regex_casei = '[a-z0-9]+';
  $o_957->attrs[] = $o_962;
  $o_963 = new AttrSpec();
  $o_963->name = 'data-site-id';
  $o_963->mandatory = true;
  $o_963->value_regex = '[0-9]+';
  $o_957->attrs[] = $o_963;
  $o_957->attr_lists = ['extended-amp-global'];
  $o_957->spec_url = 'https://github.com/ampproject/amphtml/blob/master/extensions/amp-springboard-player/amp-springboard-player.html';
  $o_964 = new AmpLayout();
  $o_964->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::RESPONSIVE];
  $o_957->amp_layout = $o_964;
  $o_957->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_957->also_requires_tag = ['amp-springboard-player extension .js script'];
  $o_0->tags[] = $o_957;
  $o_965 = new TagSpec();
  $o_965->tag_name = 'script';
  $o_965->spec_name = 'amp-sticky-ad extension .js script';
  $o_965->mandatory_parent = 'head';
  $o_966 = new AttrSpec();
  $o_966->name = 'async';
  $o_966->mandatory = true;
  $o_966->value = '';
  $o_965->attrs[] = $o_966;
  $o_967 = new AttrSpec();
  $o_967->name = 'custom-element';
  $o_967->mandatory = true;
  $o_967->value = 'amp-sticky-ad';
  $o_967->dispatch_key = true;
  $o_965->attrs[] = $o_967;
  $o_968 = new AttrSpec();
  $o_968->name = 'src';
  $o_968->mandatory = true;
  $o_968->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-sticky-ad-(latest|0\\.1)\\.js';
  $o_965->attrs[] = $o_968;
  $o_969 = new AttrSpec();
  $o_969->name = 'type';
  $o_969->value = 'text/javascript';
  $o_965->attrs[] = $o_969;
  $o_965->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-sticky-ad.html';
  $o_970 = new CdataSpec();
  $o_971 = new BlackListedCDataRegex();
  $o_971->regex = '.';
  $o_971->error_message = 'contents';
  $o_970->blacklisted_cdata_regex[] = $o_971;
  $o_965->cdata = $o_970;
  $o_0->tags[] = $o_965;
  $o_972 = new TagSpec();
  $o_972->tag_name = 'amp-sticky-ad';
  $o_972->unique = true;
  $o_972->attr_lists = ['extended-amp-global'];
  $o_972->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-sticky-ad.html';
  $o_973 = new AmpLayout();
  $o_973->supported_layouts = [AmpLayoutLayout::NODISPLAY];
  $o_972->amp_layout = $o_973;
  $o_972->disallowed_ancestor = ['amp-sidebar'];
  $o_972->also_requires_tag = ['amp-sticky-ad extension .js script'];
  $o_974 = new ChildTagSpec();
  $o_974->mandatory_num_child_tags = 1;
  $o_974->first_child_tag_name_oneof = ['amp-ad'];
  $o_972->child_tags = $o_974;
  $o_0->tags[] = $o_972;
  $o_975 = new TagSpec();
  $o_975->tag_name = 'script';
  $o_975->spec_name = 'amp-twitter extension .js script';
  $o_975->mandatory_parent = 'head';
  $o_976 = new AttrSpec();
  $o_976->name = 'async';
  $o_976->mandatory = true;
  $o_976->value = '';
  $o_975->attrs[] = $o_976;
  $o_977 = new AttrSpec();
  $o_977->name = 'custom-element';
  $o_977->mandatory = true;
  $o_977->value = 'amp-twitter';
  $o_977->dispatch_key = true;
  $o_975->attrs[] = $o_977;
  $o_978 = new AttrSpec();
  $o_978->name = 'src';
  $o_978->mandatory = true;
  $o_978->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-twitter-(latest|0\\.1).js';
  $o_975->attrs[] = $o_978;
  $o_979 = new AttrSpec();
  $o_979->name = 'type';
  $o_979->value = 'text/javascript';
  $o_975->attrs[] = $o_979;
  $o_975->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-twitter.html';
  $o_980 = new CdataSpec();
  $o_981 = new BlackListedCDataRegex();
  $o_981->regex = '.';
  $o_981->error_message = 'contents';
  $o_980->blacklisted_cdata_regex[] = $o_981;
  $o_975->cdata = $o_980;
  $o_0->tags[] = $o_975;
  $o_982 = new TagSpec();
  $o_982->tag_name = 'amp-twitter';
  $o_983 = new AttrSpec();
  $o_983->name = 'data-tweetid';
  $o_983->mandatory_oneof = '[\'data-tweetid\', \'src\']';
  $o_982->attrs[] = $o_983;
  $o_984 = new AttrSpec();
  $o_984->name = 'src';
  $o_984->mandatory_oneof = '[\'data-tweetid\', \'src\']';
  $o_985 = new UrlSpec();
  $o_985->allowed_protocol = ['http', 'https'];
  $o_985->allow_relative = true;
  $o_984->value_url = $o_985;
  $o_982->attrs[] = $o_984;
  $o_982->attr_lists = ['extended-amp-global'];
  $o_982->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-twitter.html';
  $o_986 = new AmpLayout();
  $o_986->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_982->amp_layout = $o_986;
  $o_982->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_982->also_requires_tag = ['amp-twitter extension .js script'];
  $o_0->tags[] = $o_982;
  $o_987 = new TagSpec();
  $o_987->tag_name = 'script';
  $o_987->spec_name = 'amp-user-notification extension .js script';
  $o_987->mandatory_parent = 'head';
  $o_988 = new AttrSpec();
  $o_988->name = 'async';
  $o_988->mandatory = true;
  $o_988->value = '';
  $o_987->attrs[] = $o_988;
  $o_989 = new AttrSpec();
  $o_989->name = 'custom-element';
  $o_989->mandatory = true;
  $o_989->value = 'amp-user-notification';
  $o_989->dispatch_key = true;
  $o_987->attrs[] = $o_989;
  $o_990 = new AttrSpec();
  $o_990->name = 'src';
  $o_990->mandatory = true;
  $o_990->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-user-notification-(latest|0\\.1).js';
  $o_987->attrs[] = $o_990;
  $o_991 = new AttrSpec();
  $o_991->name = 'type';
  $o_991->value = 'text/javascript';
  $o_987->attrs[] = $o_991;
  $o_987->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-user-notification.html';
  $o_992 = new CdataSpec();
  $o_993 = new BlackListedCDataRegex();
  $o_993->regex = '.';
  $o_993->error_message = 'contents';
  $o_992->blacklisted_cdata_regex[] = $o_993;
  $o_987->cdata = $o_992;
  $o_0->tags[] = $o_987;
  $o_994 = new TagSpec();
  $o_994->tag_name = 'amp-user-notification';
  $o_994->attr_lists = ['extended-amp-global'];
  $o_994->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-user-notification.html';
  $o_995 = new AmpLayout();
  $o_995->supported_layouts = [AmpLayoutLayout::NODISPLAY];
  $o_994->amp_layout = $o_995;
  $o_994->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_994->also_requires_tag = ['amp-analytics extension .js script', 'amp-user-notification extension .js script'];
  $o_0->tags[] = $o_994;
  $o_996 = new TagSpec();
  $o_996->tag_name = 'script';
  $o_996->spec_name = 'amp-vimeo extension .js script';
  $o_996->mandatory_parent = 'head';
  $o_997 = new AttrSpec();
  $o_997->name = 'async';
  $o_997->mandatory = true;
  $o_997->value = '';
  $o_996->attrs[] = $o_997;
  $o_998 = new AttrSpec();
  $o_998->name = 'custom-element';
  $o_998->mandatory = true;
  $o_998->value = 'amp-vimeo';
  $o_998->dispatch_key = true;
  $o_996->attrs[] = $o_998;
  $o_999 = new AttrSpec();
  $o_999->name = 'src';
  $o_999->mandatory = true;
  $o_999->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-vimeo-(latest|0\\.1)\\.js';
  $o_996->attrs[] = $o_999;
  $o_1000 = new AttrSpec();
  $o_1000->name = 'type';
  $o_1000->value = 'text/javascript';
  $o_996->attrs[] = $o_1000;
  $o_996->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-vimeo.html';
  $o_1001 = new CdataSpec();
  $o_1002 = new BlackListedCDataRegex();
  $o_1002->regex = '.';
  $o_1002->error_message = 'contents';
  $o_1001->blacklisted_cdata_regex[] = $o_1002;
  $o_996->cdata = $o_1001;
  $o_0->tags[] = $o_996;
  $o_1003 = new TagSpec();
  $o_1003->tag_name = 'amp-vimeo';
  $o_1004 = new AttrSpec();
  $o_1004->name = 'data-videoid';
  $o_1004->mandatory = true;
  $o_1004->value_regex = '[0-9]+';
  $o_1003->attrs[] = $o_1004;
  $o_1003->attr_lists = ['extended-amp-global'];
  $o_1003->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-vimeo.html';
  $o_1005 = new AmpLayout();
  $o_1005->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::RESPONSIVE];
  $o_1003->amp_layout = $o_1005;
  $o_1003->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_1003->also_requires_tag = ['amp-vimeo extension .js script'];
  $o_0->tags[] = $o_1003;
  $o_1006 = new TagSpec();
  $o_1006->tag_name = 'script';
  $o_1006->spec_name = 'amp-vine extension .js script';
  $o_1006->mandatory_parent = 'head';
  $o_1007 = new AttrSpec();
  $o_1007->name = 'async';
  $o_1007->mandatory = true;
  $o_1007->value = '';
  $o_1006->attrs[] = $o_1007;
  $o_1008 = new AttrSpec();
  $o_1008->name = 'custom-element';
  $o_1008->mandatory = true;
  $o_1008->value = 'amp-vine';
  $o_1008->dispatch_key = true;
  $o_1006->attrs[] = $o_1008;
  $o_1009 = new AttrSpec();
  $o_1009->name = 'src';
  $o_1009->mandatory = true;
  $o_1009->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-vine-(latest|0\\.1).js';
  $o_1006->attrs[] = $o_1009;
  $o_1010 = new AttrSpec();
  $o_1010->name = 'type';
  $o_1010->value = 'text/javascript';
  $o_1006->attrs[] = $o_1010;
  $o_1006->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-vine.html';
  $o_1011 = new CdataSpec();
  $o_1012 = new BlackListedCDataRegex();
  $o_1012->regex = '.';
  $o_1012->error_message = 'contents';
  $o_1011->blacklisted_cdata_regex[] = $o_1012;
  $o_1006->cdata = $o_1011;
  $o_0->tags[] = $o_1006;
  $o_1013 = new TagSpec();
  $o_1013->tag_name = 'amp-vine';
  $o_1014 = new AttrSpec();
  $o_1014->name = 'data-vineid';
  $o_1014->mandatory = true;
  $o_1013->attrs[] = $o_1014;
  $o_1013->attr_lists = ['extended-amp-global'];
  $o_1013->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-vine.html';
  $o_1015 = new AmpLayout();
  $o_1015->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_1013->amp_layout = $o_1015;
  $o_1013->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_1013->also_requires_tag = ['amp-vine extension .js script'];
  $o_0->tags[] = $o_1013;
  $o_1016 = new TagSpec();
  $o_1016->tag_name = 'script';
  $o_1016->spec_name = 'amp-youtube extension .js script';
  $o_1016->mandatory_parent = 'head';
  $o_1017 = new AttrSpec();
  $o_1017->name = 'async';
  $o_1017->mandatory = true;
  $o_1017->value = '';
  $o_1016->attrs[] = $o_1017;
  $o_1018 = new AttrSpec();
  $o_1018->name = 'custom-element';
  $o_1018->mandatory = true;
  $o_1018->value = 'amp-youtube';
  $o_1018->dispatch_key = true;
  $o_1016->attrs[] = $o_1018;
  $o_1019 = new AttrSpec();
  $o_1019->name = 'src';
  $o_1019->mandatory = true;
  $o_1019->value_regex = 'https://cdn\\.ampproject\\.org/v0/amp-youtube-(latest|0\\.1)\\.js';
  $o_1016->attrs[] = $o_1019;
  $o_1020 = new AttrSpec();
  $o_1020->name = 'type';
  $o_1020->value = 'text/javascript';
  $o_1016->attrs[] = $o_1020;
  $o_1016->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-youtube.html';
  $o_1021 = new CdataSpec();
  $o_1022 = new BlackListedCDataRegex();
  $o_1022->regex = '.';
  $o_1022->error_message = 'contents';
  $o_1021->blacklisted_cdata_regex[] = $o_1022;
  $o_1016->cdata = $o_1021;
  $o_0->tags[] = $o_1016;
  $o_1023 = new TagSpec();
  $o_1023->tag_name = 'amp-youtube';
  $o_1024 = new AttrSpec();
  $o_1024->name = 'data-videoid';
  $o_1024->mandatory_oneof = '[\'src\', \'data-videoid\']';
  $o_1023->attrs[] = $o_1024;
  $o_1025 = new AttrSpec();
  $o_1025->name = 'src';
  $o_1025->mandatory_oneof = '[\'src\', \'data-videoid\']';
  $o_1026 = new UrlSpec();
  $o_1026->allowed_protocol = ['http', 'https'];
  $o_1026->allow_relative = true;
  $o_1025->value_url = $o_1026;
  $o_1023->attrs[] = $o_1025;
  $o_1027 = new AttrSpec();
  $o_1027->name = 'video-id';
  $o_1027->deprecation = 'data-videoid';
  $o_1027->deprecation_url = 'https://www.ampproject.org/docs/reference/extended/amp-youtube.html';
  $o_1027->mandatory_oneof = '[\'src\', \'data-videoid\']';
  $o_1023->attrs[] = $o_1027;
  $o_1023->attr_lists = ['extended-amp-global'];
  $o_1023->spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-youtube.html';
  $o_1028 = new AmpLayout();
  $o_1028->supported_layouts = [AmpLayoutLayout::FILL, AmpLayoutLayout::FIXED, AmpLayoutLayout::FIXED_HEIGHT, AmpLayoutLayout::FLEX_ITEM, AmpLayoutLayout::NODISPLAY, AmpLayoutLayout::RESPONSIVE];
  $o_1023->amp_layout = $o_1028;
  $o_1023->disallowed_ancestor = ['head', 'amp-sidebar'];
  $o_1023->also_requires_tag = ['amp-youtube extension .js script'];
  $o_0->tags[] = $o_1023;
  $o_0->min_validator_revision_required = 135;
  $o_0->spec_file_revision = 228;
  $o_1029 = new AttrList();
  $o_1029->name = 'common-link-attrs';
  $o_1030 = new AttrSpec();
  $o_1030->name = 'media';
  $o_1029->attrs[] = $o_1030;
  $o_1031 = new AttrSpec();
  $o_1031->name = 'sizes';
  $o_1029->attrs[] = $o_1031;
  $o_1032 = new AttrSpec();
  $o_1032->name = 'target';
  $o_1029->attrs[] = $o_1032;
  $o_1033 = new AttrSpec();
  $o_1033->name = 'type';
  $o_1029->attrs[] = $o_1033;
  $o_1034 = new AttrSpec();
  $o_1034->name = 'hreflang';
  $o_1029->attrs[] = $o_1034;
  $o_1035 = new AttrSpec();
  $o_1035->name = 'charset';
  $o_1035->value = 'utf-8';
  $o_1029->attrs[] = $o_1035;
  $o_1036 = new AttrSpec();
  $o_1036->name = 'color';
  $o_1029->attrs[] = $o_1036;
  $o_0->attr_lists[] = $o_1029;
  $o_1037 = new AttrList();
  $o_1037->name = 'cite-attr';
  $o_1038 = new AttrSpec();
  $o_1038->name = 'cite';
  $o_1039 = new UrlSpec();
  $o_1039->allowed_protocol = ['http', 'https', 'mailto', 'ftp', 'fb-messenger', 'sms', 'tel', 'viber', 'whatsapp'];
  $o_1039->allow_relative = true;
  $o_1038->value_url = $o_1039;
  $o_1037->attrs[] = $o_1038;
  $o_0->attr_lists[] = $o_1037;
  $o_1040 = new AttrList();
  $o_1040->name = 'track-attrs-no-subtitles';
  $o_1041 = new AttrSpec();
  $o_1041->name = 'src';
  $o_1041->mandatory = true;
  $o_1042 = new UrlSpec();
  $o_1042->allowed_protocol = ['https'];
  $o_1042->allow_relative = false;
  $o_1041->value_url = $o_1042;
  $o_1040->attrs[] = $o_1041;
  $o_1043 = new AttrSpec();
  $o_1043->name = 'default';
  $o_1043->value = '';
  $o_1040->attrs[] = $o_1043;
  $o_1044 = new AttrSpec();
  $o_1044->name = 'kind';
  $o_1044->value_regex = '(captions|descriptions|chapters|metadata)';
  $o_1040->attrs[] = $o_1044;
  $o_1045 = new AttrSpec();
  $o_1045->name = 'label';
  $o_1040->attrs[] = $o_1045;
  $o_1046 = new AttrSpec();
  $o_1046->name = 'srclang';
  $o_1040->attrs[] = $o_1046;
  $o_0->attr_lists[] = $o_1040;
  $o_1047 = new AttrList();
  $o_1047->name = 'track-attrs-subtitles';
  $o_1048 = new AttrSpec();
  $o_1048->name = 'src';
  $o_1048->mandatory = true;
  $o_1049 = new UrlSpec();
  $o_1049->allowed_protocol = ['https'];
  $o_1049->allow_relative = false;
  $o_1048->value_url = $o_1049;
  $o_1047->attrs[] = $o_1048;
  $o_1050 = new AttrSpec();
  $o_1050->name = 'default';
  $o_1050->value = '';
  $o_1047->attrs[] = $o_1050;
  $o_1051 = new AttrSpec();
  $o_1051->name = 'kind';
  $o_1051->mandatory = true;
  $o_1051->value = 'subtitles';
  $o_1047->attrs[] = $o_1051;
  $o_1052 = new AttrSpec();
  $o_1052->name = 'label';
  $o_1047->attrs[] = $o_1052;
  $o_1053 = new AttrSpec();
  $o_1053->name = 'srclang';
  $o_1053->mandatory = true;
  $o_1047->attrs[] = $o_1053;
  $o_0->attr_lists[] = $o_1047;
  $o_1054 = new AttrList();
  $o_1054->name = 'svg-conditional-processing-attributes';
  $o_1055 = new AttrSpec();
  $o_1055->name = 'requiredextensions';
  $o_1054->attrs[] = $o_1055;
  $o_1056 = new AttrSpec();
  $o_1056->name = 'requiredfeatures';
  $o_1054->attrs[] = $o_1056;
  $o_1057 = new AttrSpec();
  $o_1057->name = 'systemlanguage';
  $o_1054->attrs[] = $o_1057;
  $o_0->attr_lists[] = $o_1054;
  $o_1058 = new AttrList();
  $o_1058->name = 'svg-core-attributes';
  $o_1059 = new AttrSpec();
  $o_1059->name = 'xml:base';
  $o_1058->attrs[] = $o_1059;
  $o_1060 = new AttrSpec();
  $o_1060->name = 'xml:lang';
  $o_1058->attrs[] = $o_1060;
  $o_1061 = new AttrSpec();
  $o_1061->name = 'xml:space';
  $o_1058->attrs[] = $o_1061;
  $o_1062 = new AttrSpec();
  $o_1062->name = 'xmlns';
  $o_1058->attrs[] = $o_1062;
  $o_1063 = new AttrSpec();
  $o_1063->name = 'xmlns:xlink';
  $o_1058->attrs[] = $o_1063;
  $o_0->attr_lists[] = $o_1058;
  $o_1064 = new AttrList();
  $o_1064->name = 'svg-filter-primitive-attributes';
  $o_1065 = new AttrSpec();
  $o_1065->name = 'height';
  $o_1064->attrs[] = $o_1065;
  $o_1066 = new AttrSpec();
  $o_1066->name = 'result';
  $o_1064->attrs[] = $o_1066;
  $o_1067 = new AttrSpec();
  $o_1067->name = 'width';
  $o_1064->attrs[] = $o_1067;
  $o_1068 = new AttrSpec();
  $o_1068->name = 'x';
  $o_1064->attrs[] = $o_1068;
  $o_1069 = new AttrSpec();
  $o_1069->name = 'y';
  $o_1064->attrs[] = $o_1069;
  $o_0->attr_lists[] = $o_1064;
  $o_1070 = new AttrList();
  $o_1070->name = 'svg-presentation-attributes';
  $o_1071 = new AttrSpec();
  $o_1071->name = 'alignment-baseline';
  $o_1070->attrs[] = $o_1071;
  $o_1072 = new AttrSpec();
  $o_1072->name = 'baseline-shift';
  $o_1070->attrs[] = $o_1072;
  $o_1073 = new AttrSpec();
  $o_1073->name = 'clip';
  $o_1070->attrs[] = $o_1073;
  $o_1074 = new AttrSpec();
  $o_1074->name = 'clip-path';
  $o_1070->attrs[] = $o_1074;
  $o_1075 = new AttrSpec();
  $o_1075->name = 'clip-rule';
  $o_1070->attrs[] = $o_1075;
  $o_1076 = new AttrSpec();
  $o_1076->name = 'color';
  $o_1070->attrs[] = $o_1076;
  $o_1077 = new AttrSpec();
  $o_1077->name = 'color-interpolation';
  $o_1070->attrs[] = $o_1077;
  $o_1078 = new AttrSpec();
  $o_1078->name = 'color-interpolation-filters';
  $o_1070->attrs[] = $o_1078;
  $o_1079 = new AttrSpec();
  $o_1079->name = 'color-profile';
  $o_1070->attrs[] = $o_1079;
  $o_1080 = new AttrSpec();
  $o_1080->name = 'color-rendering';
  $o_1070->attrs[] = $o_1080;
  $o_1081 = new AttrSpec();
  $o_1081->name = 'cursor';
  $o_1070->attrs[] = $o_1081;
  $o_1082 = new AttrSpec();
  $o_1082->name = 'direction';
  $o_1070->attrs[] = $o_1082;
  $o_1083 = new AttrSpec();
  $o_1083->name = 'display';
  $o_1070->attrs[] = $o_1083;
  $o_1084 = new AttrSpec();
  $o_1084->name = 'dominant-baseline';
  $o_1070->attrs[] = $o_1084;
  $o_1085 = new AttrSpec();
  $o_1085->name = 'enable-background';
  $o_1070->attrs[] = $o_1085;
  $o_1086 = new AttrSpec();
  $o_1086->name = 'fill';
  $o_1070->attrs[] = $o_1086;
  $o_1087 = new AttrSpec();
  $o_1087->name = 'fill-opacity';
  $o_1070->attrs[] = $o_1087;
  $o_1088 = new AttrSpec();
  $o_1088->name = 'fill-rule';
  $o_1070->attrs[] = $o_1088;
  $o_1089 = new AttrSpec();
  $o_1089->name = 'filter';
  $o_1070->attrs[] = $o_1089;
  $o_1090 = new AttrSpec();
  $o_1090->name = 'flood-color';
  $o_1070->attrs[] = $o_1090;
  $o_1091 = new AttrSpec();
  $o_1091->name = 'flood-opacity';
  $o_1070->attrs[] = $o_1091;
  $o_1092 = new AttrSpec();
  $o_1092->name = 'font-family';
  $o_1070->attrs[] = $o_1092;
  $o_1093 = new AttrSpec();
  $o_1093->name = 'font-size';
  $o_1070->attrs[] = $o_1093;
  $o_1094 = new AttrSpec();
  $o_1094->name = 'font-size-adjust';
  $o_1070->attrs[] = $o_1094;
  $o_1095 = new AttrSpec();
  $o_1095->name = 'font-stretch';
  $o_1070->attrs[] = $o_1095;
  $o_1096 = new AttrSpec();
  $o_1096->name = 'font-style';
  $o_1070->attrs[] = $o_1096;
  $o_1097 = new AttrSpec();
  $o_1097->name = 'font-variant';
  $o_1070->attrs[] = $o_1097;
  $o_1098 = new AttrSpec();
  $o_1098->name = 'font-weight';
  $o_1070->attrs[] = $o_1098;
  $o_1099 = new AttrSpec();
  $o_1099->name = 'glyph-orientation-horizontal';
  $o_1070->attrs[] = $o_1099;
  $o_1100 = new AttrSpec();
  $o_1100->name = 'glyph-orientation-vertical';
  $o_1070->attrs[] = $o_1100;
  $o_1101 = new AttrSpec();
  $o_1101->name = 'image-rendering';
  $o_1070->attrs[] = $o_1101;
  $o_1102 = new AttrSpec();
  $o_1102->name = 'kerning';
  $o_1070->attrs[] = $o_1102;
  $o_1103 = new AttrSpec();
  $o_1103->name = 'letter-spacing';
  $o_1070->attrs[] = $o_1103;
  $o_1104 = new AttrSpec();
  $o_1104->name = 'lighting-color';
  $o_1070->attrs[] = $o_1104;
  $o_1105 = new AttrSpec();
  $o_1105->name = 'marker-end';
  $o_1070->attrs[] = $o_1105;
  $o_1106 = new AttrSpec();
  $o_1106->name = 'marker-mid';
  $o_1070->attrs[] = $o_1106;
  $o_1107 = new AttrSpec();
  $o_1107->name = 'marker-start';
  $o_1070->attrs[] = $o_1107;
  $o_1108 = new AttrSpec();
  $o_1108->name = 'mask';
  $o_1070->attrs[] = $o_1108;
  $o_1109 = new AttrSpec();
  $o_1109->name = 'opacity';
  $o_1070->attrs[] = $o_1109;
  $o_1110 = new AttrSpec();
  $o_1110->name = 'overflow';
  $o_1070->attrs[] = $o_1110;
  $o_1111 = new AttrSpec();
  $o_1111->name = 'pointer-events';
  $o_1070->attrs[] = $o_1111;
  $o_1112 = new AttrSpec();
  $o_1112->name = 'shape-rendering';
  $o_1070->attrs[] = $o_1112;
  $o_1113 = new AttrSpec();
  $o_1113->name = 'stop-color';
  $o_1070->attrs[] = $o_1113;
  $o_1114 = new AttrSpec();
  $o_1114->name = 'stop-opacity';
  $o_1070->attrs[] = $o_1114;
  $o_1115 = new AttrSpec();
  $o_1115->name = 'stroke';
  $o_1070->attrs[] = $o_1115;
  $o_1116 = new AttrSpec();
  $o_1116->name = 'stroke-dasharray';
  $o_1070->attrs[] = $o_1116;
  $o_1117 = new AttrSpec();
  $o_1117->name = 'stroke-dashoffset';
  $o_1070->attrs[] = $o_1117;
  $o_1118 = new AttrSpec();
  $o_1118->name = 'stroke-linecap';
  $o_1070->attrs[] = $o_1118;
  $o_1119 = new AttrSpec();
  $o_1119->name = 'stroke-linejoin';
  $o_1070->attrs[] = $o_1119;
  $o_1120 = new AttrSpec();
  $o_1120->name = 'stroke-miterlimit';
  $o_1070->attrs[] = $o_1120;
  $o_1121 = new AttrSpec();
  $o_1121->name = 'stroke-opacity';
  $o_1070->attrs[] = $o_1121;
  $o_1122 = new AttrSpec();
  $o_1122->name = 'stroke-width';
  $o_1070->attrs[] = $o_1122;
  $o_1123 = new AttrSpec();
  $o_1123->name = 'text-anchor';
  $o_1070->attrs[] = $o_1123;
  $o_1124 = new AttrSpec();
  $o_1124->name = 'text-decoration';
  $o_1070->attrs[] = $o_1124;
  $o_1125 = new AttrSpec();
  $o_1125->name = 'text-rendering';
  $o_1070->attrs[] = $o_1125;
  $o_1126 = new AttrSpec();
  $o_1126->name = 'unicode-bidi';
  $o_1070->attrs[] = $o_1126;
  $o_1127 = new AttrSpec();
  $o_1127->name = 'visibility';
  $o_1070->attrs[] = $o_1127;
  $o_1128 = new AttrSpec();
  $o_1128->name = 'word-spacing';
  $o_1070->attrs[] = $o_1128;
  $o_1129 = new AttrSpec();
  $o_1129->name = 'writing-mode';
  $o_1070->attrs[] = $o_1129;
  $o_0->attr_lists[] = $o_1070;
  $o_1130 = new AttrList();
  $o_1130->name = 'svg-transfer-function-attributes';
  $o_1131 = new AttrSpec();
  $o_1131->name = 'amplitude';
  $o_1130->attrs[] = $o_1131;
  $o_1132 = new AttrSpec();
  $o_1132->name = 'exponent';
  $o_1130->attrs[] = $o_1132;
  $o_1133 = new AttrSpec();
  $o_1133->name = 'intercept';
  $o_1130->attrs[] = $o_1133;
  $o_1134 = new AttrSpec();
  $o_1134->name = 'offset';
  $o_1130->attrs[] = $o_1134;
  $o_1135 = new AttrSpec();
  $o_1135->name = 'slope';
  $o_1130->attrs[] = $o_1135;
  $o_1136 = new AttrSpec();
  $o_1136->name = 'table';
  $o_1130->attrs[] = $o_1136;
  $o_1137 = new AttrSpec();
  $o_1137->name = 'tablevalues';
  $o_1130->attrs[] = $o_1137;
  $o_0->attr_lists[] = $o_1130;
  $o_1138 = new AttrList();
  $o_1138->name = 'svg-xlink-attributes';
  $o_1139 = new AttrSpec();
  $o_1139->name = 'xlink:actuate';
  $o_1138->attrs[] = $o_1139;
  $o_1140 = new AttrSpec();
  $o_1140->name = 'xlink:arcrole';
  $o_1138->attrs[] = $o_1140;
  $o_1141 = new AttrSpec();
  $o_1141->name = 'xlink:href';
  $o_1141->value_regex = '#.*';
  $o_1138->attrs[] = $o_1141;
  $o_1142 = new AttrSpec();
  $o_1142->name = 'xlink:role';
  $o_1138->attrs[] = $o_1142;
  $o_1143 = new AttrSpec();
  $o_1143->name = 'xlink:show';
  $o_1138->attrs[] = $o_1143;
  $o_1144 = new AttrSpec();
  $o_1144->name = 'xlink:title';
  $o_1138->attrs[] = $o_1144;
  $o_1145 = new AttrSpec();
  $o_1145->name = 'xlink:type';
  $o_1138->attrs[] = $o_1145;
  $o_0->attr_lists[] = $o_1138;
  $o_1146 = new AttrList();
  $o_1146->name = 'mandatory-src-or-srcset';
  $o_1147 = new AttrSpec();
  $o_1147->name = 'src';
  $o_1147->alternative_names = ['srcset'];
  $o_1147->mandatory = true;
  $o_1148 = new UrlSpec();
  $o_1148->allowed_protocol = ['data', 'http', 'https'];
  $o_1148->allow_relative = true;
  $o_1147->value_url = $o_1148;
  $o_1146->attrs[] = $o_1147;
  $o_0->attr_lists[] = $o_1146;
  $o_1149 = new AttrList();
  $o_1149->name = 'extended-amp-global';
  $o_1150 = new AttrSpec();
  $o_1150->name = 'media';
  $o_1149->attrs[] = $o_1150;
  $o_1151 = new AttrSpec();
  $o_1151->name = 'noloading';
  $o_1151->value = '';
  $o_1149->attrs[] = $o_1151;
  $o_0->attr_lists[] = $o_1149;
  $o_1152 = new AttrList();
  $o_1152->name = '$AMP_LAYOUT_ATTRS';
  $o_1153 = new AttrSpec();
  $o_1153->name = 'height';
  $o_1152->attrs[] = $o_1153;
  $o_1154 = new AttrSpec();
  $o_1154->name = 'heights';
  $o_1152->attrs[] = $o_1154;
  $o_1155 = new AttrSpec();
  $o_1155->name = 'layout';
  $o_1152->attrs[] = $o_1155;
  $o_1156 = new AttrSpec();
  $o_1156->name = 'sizes';
  $o_1152->attrs[] = $o_1156;
  $o_1157 = new AttrSpec();
  $o_1157->name = 'width';
  $o_1152->attrs[] = $o_1157;
  $o_0->attr_lists[] = $o_1152;
  $o_1158 = new AttrList();
  $o_1158->name = '$GLOBAL_ATTRS';
  $o_1159 = new AttrSpec();
  $o_1159->name = 'itemid';
  $o_1158->attrs[] = $o_1159;
  $o_1160 = new AttrSpec();
  $o_1160->name = 'itemprop';
  $o_1158->attrs[] = $o_1160;
  $o_1161 = new AttrSpec();
  $o_1161->name = 'itemref';
  $o_1158->attrs[] = $o_1161;
  $o_1162 = new AttrSpec();
  $o_1162->name = 'itemscope';
  $o_1158->attrs[] = $o_1162;
  $o_1163 = new AttrSpec();
  $o_1163->name = 'itemtype';
  $o_1158->attrs[] = $o_1163;
  $o_1164 = new AttrSpec();
  $o_1164->name = 'accesskey';
  $o_1158->attrs[] = $o_1164;
  $o_1165 = new AttrSpec();
  $o_1165->name = 'class';
  $o_1158->attrs[] = $o_1165;
  $o_1166 = new AttrSpec();
  $o_1166->name = 'dir';
  $o_1158->attrs[] = $o_1166;
  $o_1167 = new AttrSpec();
  $o_1167->name = 'draggable';
  $o_1158->attrs[] = $o_1167;
  $o_1168 = new AttrSpec();
  $o_1168->name = 'id';
  $o_1158->attrs[] = $o_1168;
  $o_1169 = new AttrSpec();
  $o_1169->name = 'lang';
  $o_1158->attrs[] = $o_1169;
  $o_1170 = new AttrSpec();
  $o_1170->name = 'tabindex';
  $o_1158->attrs[] = $o_1170;
  $o_1171 = new AttrSpec();
  $o_1171->name = 'title';
  $o_1158->attrs[] = $o_1171;
  $o_1172 = new AttrSpec();
  $o_1172->name = 'translate';
  $o_1158->attrs[] = $o_1172;
  $o_1173 = new AttrSpec();
  $o_1173->name = 'aria-activedescendant';
  $o_1158->attrs[] = $o_1173;
  $o_1174 = new AttrSpec();
  $o_1174->name = 'aria-atomic';
  $o_1158->attrs[] = $o_1174;
  $o_1175 = new AttrSpec();
  $o_1175->name = 'aria-autocomplete';
  $o_1158->attrs[] = $o_1175;
  $o_1176 = new AttrSpec();
  $o_1176->name = 'aria-busy';
  $o_1158->attrs[] = $o_1176;
  $o_1177 = new AttrSpec();
  $o_1177->name = 'aria-checked';
  $o_1158->attrs[] = $o_1177;
  $o_1178 = new AttrSpec();
  $o_1178->name = 'aria-controls';
  $o_1158->attrs[] = $o_1178;
  $o_1179 = new AttrSpec();
  $o_1179->name = 'aria-describedby';
  $o_1158->attrs[] = $o_1179;
  $o_1180 = new AttrSpec();
  $o_1180->name = 'aria-disabled';
  $o_1158->attrs[] = $o_1180;
  $o_1181 = new AttrSpec();
  $o_1181->name = 'aria-dropeffect';
  $o_1158->attrs[] = $o_1181;
  $o_1182 = new AttrSpec();
  $o_1182->name = 'aria-expanded';
  $o_1158->attrs[] = $o_1182;
  $o_1183 = new AttrSpec();
  $o_1183->name = 'aria-flowto';
  $o_1158->attrs[] = $o_1183;
  $o_1184 = new AttrSpec();
  $o_1184->name = 'aria-grabbed';
  $o_1158->attrs[] = $o_1184;
  $o_1185 = new AttrSpec();
  $o_1185->name = 'aria-haspopup';
  $o_1158->attrs[] = $o_1185;
  $o_1186 = new AttrSpec();
  $o_1186->name = 'aria-hidden';
  $o_1158->attrs[] = $o_1186;
  $o_1187 = new AttrSpec();
  $o_1187->name = 'aria-invalid';
  $o_1158->attrs[] = $o_1187;
  $o_1188 = new AttrSpec();
  $o_1188->name = 'aria-label';
  $o_1158->attrs[] = $o_1188;
  $o_1189 = new AttrSpec();
  $o_1189->name = 'aria-labelledby';
  $o_1158->attrs[] = $o_1189;
  $o_1190 = new AttrSpec();
  $o_1190->name = 'aria-level';
  $o_1158->attrs[] = $o_1190;
  $o_1191 = new AttrSpec();
  $o_1191->name = 'aria-live';
  $o_1158->attrs[] = $o_1191;
  $o_1192 = new AttrSpec();
  $o_1192->name = 'aria-multiline';
  $o_1158->attrs[] = $o_1192;
  $o_1193 = new AttrSpec();
  $o_1193->name = 'aria-multiselectable';
  $o_1158->attrs[] = $o_1193;
  $o_1194 = new AttrSpec();
  $o_1194->name = 'aria-orientation';
  $o_1158->attrs[] = $o_1194;
  $o_1195 = new AttrSpec();
  $o_1195->name = 'aria-owns';
  $o_1158->attrs[] = $o_1195;
  $o_1196 = new AttrSpec();
  $o_1196->name = 'aria-posinset';
  $o_1158->attrs[] = $o_1196;
  $o_1197 = new AttrSpec();
  $o_1197->name = 'aria-pressed';
  $o_1158->attrs[] = $o_1197;
  $o_1198 = new AttrSpec();
  $o_1198->name = 'aria-readonly';
  $o_1158->attrs[] = $o_1198;
  $o_1199 = new AttrSpec();
  $o_1199->name = 'aria-relevant';
  $o_1158->attrs[] = $o_1199;
  $o_1200 = new AttrSpec();
  $o_1200->name = 'aria-required';
  $o_1158->attrs[] = $o_1200;
  $o_1201 = new AttrSpec();
  $o_1201->name = 'aria-selected';
  $o_1158->attrs[] = $o_1201;
  $o_1202 = new AttrSpec();
  $o_1202->name = 'aria-setsize';
  $o_1158->attrs[] = $o_1202;
  $o_1203 = new AttrSpec();
  $o_1203->name = 'aria-sort';
  $o_1158->attrs[] = $o_1203;
  $o_1204 = new AttrSpec();
  $o_1204->name = 'aria-valuemax';
  $o_1158->attrs[] = $o_1204;
  $o_1205 = new AttrSpec();
  $o_1205->name = 'aria-valuemin';
  $o_1158->attrs[] = $o_1205;
  $o_1206 = new AttrSpec();
  $o_1206->name = 'aria-valuenow';
  $o_1158->attrs[] = $o_1206;
  $o_1207 = new AttrSpec();
  $o_1207->name = 'aria-valuetext';
  $o_1158->attrs[] = $o_1207;
  $o_1208 = new AttrSpec();
  $o_1208->name = 'on';
  $o_1209 = new AttrTriggerSpec();
  $o_1209->if_value_regex = 'tap:.*';
  $o_1209->also_requires_attr = ['role', 'tabindex'];
  $o_1208->trigger = $o_1209;
  $o_1158->attrs[] = $o_1208;
  $o_1210 = new AttrSpec();
  $o_1210->name = 'role';
  $o_1158->attrs[] = $o_1210;
  $o_1211 = new AttrSpec();
  $o_1211->name = 'placeholder';
  $o_1211->value = '';
  $o_1158->attrs[] = $o_1211;
  $o_1212 = new AttrSpec();
  $o_1212->name = 'fallback';
  $o_1212->value = '';
  $o_1158->attrs[] = $o_1212;
  $o_1213 = new AttrSpec();
  $o_1213->name = 'lightbox';
  $o_1158->attrs[] = $o_1213;
  $o_1214 = new AttrSpec();
  $o_1214->name = 'overflow';
  $o_1158->attrs[] = $o_1214;
  $o_1215 = new AttrSpec();
  $o_1215->name = 'amp-access';
  $o_1158->attrs[] = $o_1215;
  $o_1216 = new AttrSpec();
  $o_1216->name = 'amp-access-behavior';
  $o_1158->attrs[] = $o_1216;
  $o_1217 = new AttrSpec();
  $o_1217->name = 'amp-access-hide';
  $o_1158->attrs[] = $o_1217;
  $o_1218 = new AttrSpec();
  $o_1218->name = 'amp-access-id';
  $o_1158->attrs[] = $o_1218;
  $o_1219 = new AttrSpec();
  $o_1219->name = 'amp-access-loader';
  $o_1158->attrs[] = $o_1219;
  $o_1220 = new AttrSpec();
  $o_1220->name = 'amp-access-loading';
  $o_1158->attrs[] = $o_1220;
  $o_1221 = new AttrSpec();
  $o_1221->name = 'amp-access-off';
  $o_1158->attrs[] = $o_1221;
  $o_1222 = new AttrSpec();
  $o_1222->name = 'amp-access-on';
  $o_1158->attrs[] = $o_1222;
  $o_1223 = new AttrSpec();
  $o_1223->name = 'amp-access-show';
  $o_1158->attrs[] = $o_1223;
  $o_1224 = new AttrSpec();
  $o_1224->name = 'amp-access-style';
  $o_1158->attrs[] = $o_1224;
  $o_1225 = new AttrSpec();
  $o_1225->name = 'amp-access-template';
  $o_1158->attrs[] = $o_1225;
  $o_1226 = new AttrSpec();
  $o_1226->name = 'i-amp-access-id';
  $o_1158->attrs[] = $o_1226;
  $o_0->attr_lists[] = $o_1158;
  $o_0->template_spec_url = 'https://www.ampproject.org/docs/reference/extended/amp-mustache.html';
  $o_1227 = new ErrorFormat();
  $o_1227->code = ValidationErrorCode::UNKNOWN_CODE;
  $o_1227->format = 'Unknown error.';
  $o_0->error_formats[] = $o_1227;
  $o_1228 = new ErrorFormat();
  $o_1228->code = ValidationErrorCode::MANDATORY_TAG_MISSING;
  $o_1228->format = 'The mandatory tag \'%1\' is missing or incorrect.';
  $o_0->error_formats[] = $o_1228;
  $o_1229 = new ErrorFormat();
  $o_1229->code = ValidationErrorCode::TAG_REQUIRED_BY_MISSING;
  $o_1229->format = 'The tag \'%1\' is missing or incorrect, but required by \'%2\'.';
  $o_0->error_formats[] = $o_1229;
  $o_1230 = new ErrorFormat();
  $o_1230->code = ValidationErrorCode::ATTR_REQUIRED_BUT_MISSING;
  $o_1230->format = 'The attribute \'%1\' in tag \'%2\' is missing or incorrect, but required by attribute \'%3\'.';
  $o_0->error_formats[] = $o_1230;
  $o_1231 = new ErrorFormat();
  $o_1231->code = ValidationErrorCode::DISALLOWED_TAG;
  $o_1231->format = 'The tag \'%1\' is disallowed.';
  $o_0->error_formats[] = $o_1231;
  $o_1232 = new ErrorFormat();
  $o_1232->code = ValidationErrorCode::GENERAL_DISALLOWED_TAG;
  $o_1232->format = 'The tag \'%1\' is disallowed except in specific forms.';
  $o_0->error_formats[] = $o_1232;
  $o_1233 = new ErrorFormat();
  $o_1233->code = ValidationErrorCode::DISALLOWED_ATTR;
  $o_1233->format = 'The attribute \'%1\' may not appear in tag \'%2\'.';
  $o_0->error_formats[] = $o_1233;
  $o_1234 = new ErrorFormat();
  $o_1234->code = ValidationErrorCode::INVALID_ATTR_VALUE;
  $o_1234->format = 'The attribute \'%1\' in tag \'%2\' is set to the invalid value \'%3\'.';
  $o_0->error_formats[] = $o_1234;
  $o_1235 = new ErrorFormat();
  $o_1235->code = ValidationErrorCode::ATTR_VALUE_REQUIRED_BY_LAYOUT;
  $o_1235->format = 'Invalid value \'%1\' for attribute \'%2\' in tag \'%3\' - for layout \'%4\', set the attribute \'%2\' to value \'%5\'.';
  $o_0->error_formats[] = $o_1235;
  $o_1236 = new ErrorFormat();
  $o_1236->code = ValidationErrorCode::IMPLIED_LAYOUT_INVALID;
  $o_1236->format = 'The implied layout \'%1\' is not supported by tag \'%2\'.';
  $o_0->error_formats[] = $o_1236;
  $o_1237 = new ErrorFormat();
  $o_1237->code = ValidationErrorCode::SPECIFIED_LAYOUT_INVALID;
  $o_1237->format = 'The specified layout \'%1\' is not supported by tag \'%2\'.';
  $o_0->error_formats[] = $o_1237;
  $o_1238 = new ErrorFormat();
  $o_1238->code = ValidationErrorCode::MANDATORY_ATTR_MISSING;
  $o_1238->format = 'The mandatory attribute \'%1\' is missing in tag \'%2\'.';
  $o_0->error_formats[] = $o_1238;
  $o_1239 = new ErrorFormat();
  $o_1239->code = ValidationErrorCode::INCONSISTENT_UNITS_FOR_WIDTH_AND_HEIGHT;
  $o_1239->format = 'Inconsistent units for width and height in tag \'%1\' - width is specified in \'%2\' whereas height is specified in \'%3\'.';
  $o_0->error_formats[] = $o_1239;
  $o_1240 = new ErrorFormat();
  $o_1240->code = ValidationErrorCode::STYLESHEET_TOO_LONG_OLD_VARIANT;
  $o_1240->format = 'The author stylesheet specified in tag \'style amp-custom\' is too long - we saw %1 bytes whereas the limit is %2 bytes.';
  $o_0->error_formats[] = $o_1240;
  $o_1241 = new ErrorFormat();
  $o_1241->code = ValidationErrorCode::STYLESHEET_TOO_LONG;
  $o_1241->format = 'The author stylesheet specified in tag \'%1\' is too long - we saw %2 bytes whereas the limit is %3 bytes.';
  $o_0->error_formats[] = $o_1241;
  $o_1242 = new ErrorFormat();
  $o_1242->code = ValidationErrorCode::MANDATORY_CDATA_MISSING_OR_INCORRECT;
  $o_1242->format = 'The mandatory text (CDATA) inside tag \'%1\' is missing or incorrect.';
  $o_0->error_formats[] = $o_1242;
  $o_1243 = new ErrorFormat();
  $o_1243->code = ValidationErrorCode::CDATA_VIOLATES_BLACKLIST;
  $o_1243->format = 'The text (CDATA) inside tag \'%1\' contains \'%2\', which is disallowed.';
  $o_0->error_formats[] = $o_1243;
  $o_1244 = new ErrorFormat();
  $o_1244->code = ValidationErrorCode::DISALLOWED_PROPERTY_IN_ATTR_VALUE;
  $o_1244->format = 'The property \'%1\' in attribute \'%2\' in tag \'%3\' is disallowed.';
  $o_0->error_formats[] = $o_1244;
  $o_1245 = new ErrorFormat();
  $o_1245->code = ValidationErrorCode::INVALID_PROPERTY_VALUE_IN_ATTR_VALUE;
  $o_1245->format = 'The property \'%1\' in attribute \'%2\' in tag \'%3\' is set to \'%4\', which is invalid.';
  $o_0->error_formats[] = $o_1245;
  $o_1246 = new ErrorFormat();
  $o_1246->code = ValidationErrorCode::DUPLICATE_DIMENSION;
  $o_1246->format = 'Multiple image candidates with the same width or pixel density found in attribute \'%1\' in tag \'%2\'.';
  $o_0->error_formats[] = $o_1246;
  $o_1247 = new ErrorFormat();
  $o_1247->code = ValidationErrorCode::MISSING_URL;
  $o_1247->format = 'Missing URL for attribute \'%1\' in tag \'%2\'.';
  $o_0->error_formats[] = $o_1247;
  $o_1248 = new ErrorFormat();
  $o_1248->code = ValidationErrorCode::INVALID_URL;
  $o_1248->format = 'Malformed URL \'%3\' for attribute \'%1\' in tag \'%2\'.';
  $o_0->error_formats[] = $o_1248;
  $o_1249 = new ErrorFormat();
  $o_1249->code = ValidationErrorCode::INVALID_URL_PROTOCOL;
  $o_1249->format = 'Invalid URL protocol \'%3:\' for attribute \'%1\' in tag \'%2\'.';
  $o_0->error_formats[] = $o_1249;
  $o_1250 = new ErrorFormat();
  $o_1250->code = ValidationErrorCode::DISALLOWED_RELATIVE_URL;
  $o_1250->format = 'The relative URL \'%3\' for attribute \'%1\' in tag \'%2\' is disallowed.';
  $o_0->error_formats[] = $o_1250;
  $o_1251 = new ErrorFormat();
  $o_1251->code = ValidationErrorCode::MANDATORY_PROPERTY_MISSING_FROM_ATTR_VALUE;
  $o_1251->format = 'The property \'%1\' is missing from attribute \'%2\' in tag \'%3\'.';
  $o_0->error_formats[] = $o_1251;
  $o_1252 = new ErrorFormat();
  $o_1252->code = ValidationErrorCode::UNESCAPED_TEMPLATE_IN_ATTR_VALUE;
  $o_1252->format = 'The attribute \'%1\' in tag \'%2\' is set to \'%3\', which contains unescaped Mustache template syntax.';
  $o_0->error_formats[] = $o_1252;
  $o_1253 = new ErrorFormat();
  $o_1253->code = ValidationErrorCode::TEMPLATE_PARTIAL_IN_ATTR_VALUE;
  $o_1253->format = 'The attribute \'%1\' in tag \'%2\' is set to \'%3\', which contains a Mustache template partial.';
  $o_0->error_formats[] = $o_1253;
  $o_1254 = new ErrorFormat();
  $o_1254->code = ValidationErrorCode::DEPRECATED_TAG;
  $o_1254->format = 'The tag \'%1\' is deprecated - use \'%2\' instead.';
  $o_0->error_formats[] = $o_1254;
  $o_1255 = new ErrorFormat();
  $o_1255->code = ValidationErrorCode::DEPRECATED_ATTR;
  $o_1255->format = 'The attribute \'%1\' in tag \'%2\' is deprecated - use \'%3\' instead.';
  $o_0->error_formats[] = $o_1255;
  $o_1256 = new ErrorFormat();
  $o_1256->code = ValidationErrorCode::DEV_MODE_ENABLED;
  $o_1256->format = 'The attribute \'%1\' in tag \'%2\' enables the development mode. Please remove, this feature is obsolete.';
  $o_0->error_formats[] = $o_1256;
  $o_1257 = new ErrorFormat();
  $o_1257->code = ValidationErrorCode::MUTUALLY_EXCLUSIVE_ATTRS;
  $o_1257->format = 'Mutually exclusive attributes encountered in tag \'%1\' - pick one of %2.';
  $o_0->error_formats[] = $o_1257;
  $o_1258 = new ErrorFormat();
  $o_1258->code = ValidationErrorCode::MANDATORY_ONEOF_ATTR_MISSING;
  $o_1258->format = 'The tag \'%1\' is missing a mandatory attribute - pick one of %2.';
  $o_0->error_formats[] = $o_1258;
  $o_1259 = new ErrorFormat();
  $o_1259->code = ValidationErrorCode::WRONG_PARENT_TAG;
  $o_1259->format = 'The parent tag of tag \'%1\' is \'%2\', but it can only be \'%3\'.';
  $o_0->error_formats[] = $o_1259;
  $o_1260 = new ErrorFormat();
  $o_1260->code = ValidationErrorCode::DISALLOWED_TAG_ANCESTOR;
  $o_1260->format = 'The tag \'%1\' may not appear as a descendant of tag \'%2\'.';
  $o_0->error_formats[] = $o_1260;
  $o_1261 = new ErrorFormat();
  $o_1261->code = ValidationErrorCode::MANDATORY_TAG_ANCESTOR;
  $o_1261->format = 'The tag \'%1\' may only appear as a descendant of tag \'%2\'.';
  $o_0->error_formats[] = $o_1261;
  $o_1262 = new ErrorFormat();
  $o_1262->code = ValidationErrorCode::MANDATORY_TAG_ANCESTOR_WITH_HINT;
  $o_1262->format = 'The tag \'%1\' may only appear as a descendant of tag \'%2\'. Did you mean \'%3\'?';
  $o_0->error_formats[] = $o_1262;
  $o_1263 = new ErrorFormat();
  $o_1263->code = ValidationErrorCode::DUPLICATE_UNIQUE_TAG;
  $o_1263->format = 'The tag \'%1\' appears more than once in the document.';
  $o_0->error_formats[] = $o_1263;
  $o_1264 = new ErrorFormat();
  $o_1264->code = ValidationErrorCode::TEMPLATE_IN_ATTR_NAME;
  $o_1264->format = 'Mustache template syntax in attribute name \'%1\' in tag \'%2\'.';
  $o_0->error_formats[] = $o_1264;
  $o_1265 = new ErrorFormat();
  $o_1265->code = ValidationErrorCode::ATTR_DISALLOWED_BY_IMPLIED_LAYOUT;
  $o_1265->format = 'The attribute \'%1\' in tag \'%2\' is disallowed by implied layout \'%3\'.';
  $o_0->error_formats[] = $o_1265;
  $o_1266 = new ErrorFormat();
  $o_1266->code = ValidationErrorCode::ATTR_DISALLOWED_BY_SPECIFIED_LAYOUT;
  $o_1266->format = 'The attribute \'%1\' in tag \'%2\' is disallowed by specified layout \'%3\'.';
  $o_0->error_formats[] = $o_1266;
  $o_1267 = new ErrorFormat();
  $o_1267->code = ValidationErrorCode::INCORRECT_NUM_CHILD_TAGS;
  $o_1267->format = 'Tag \'%1\' must have %2 child tags - saw %3 child tags.';
  $o_0->error_formats[] = $o_1267;
  $o_1268 = new ErrorFormat();
  $o_1268->code = ValidationErrorCode::DISALLOWED_CHILD_TAG_NAME;
  $o_1268->format = 'Tag \'%1\' is disallowed as child of tag \'%2\'. Child tag must be one of %3.';
  $o_0->error_formats[] = $o_1268;
  $o_1269 = new ErrorFormat();
  $o_1269->code = ValidationErrorCode::DISALLOWED_FIRST_CHILD_TAG_NAME;
  $o_1269->format = 'Tag \'%1\' is disallowed as first child of tag \'%2\'. First child tag must be one of %3.';
  $o_0->error_formats[] = $o_1269;
  $o_1270 = new ErrorFormat();
  $o_1270->code = ValidationErrorCode::CSS_SYNTAX;
  $o_1270->format = 'CSS syntax error in tag \'%1\' - %2.';
  $o_0->error_formats[] = $o_1270;
  $o_1271 = new ErrorFormat();
  $o_1271->code = ValidationErrorCode::CSS_SYNTAX_INVALID_AT_RULE;
  $o_1271->format = 'CSS syntax error in tag \'%1\' - saw invalid at rule \'@%2\'.';
  $o_0->error_formats[] = $o_1271;
  $o_1272 = new ErrorFormat();
  $o_1272->code = ValidationErrorCode::CSS_SYNTAX_STRAY_TRAILING_BACKSLASH;
  $o_1272->format = 'CSS syntax error in tag \'%1\' - stray trailing backslash.';
  $o_0->error_formats[] = $o_1272;
  $o_1273 = new ErrorFormat();
  $o_1273->code = ValidationErrorCode::CSS_SYNTAX_UNTERMINATED_COMMENT;
  $o_1273->format = 'CSS syntax error in tag \'%1\' - unterminated comment.';
  $o_0->error_formats[] = $o_1273;
  $o_1274 = new ErrorFormat();
  $o_1274->code = ValidationErrorCode::CSS_SYNTAX_UNTERMINATED_STRING;
  $o_1274->format = 'CSS syntax error in tag \'%1\' - unterminated string.';
  $o_0->error_formats[] = $o_1274;
  $o_1275 = new ErrorFormat();
  $o_1275->code = ValidationErrorCode::CSS_SYNTAX_BAD_URL;
  $o_1275->format = 'CSS syntax error in tag \'%1\' - bad url.';
  $o_0->error_formats[] = $o_1275;
  $o_1276 = new ErrorFormat();
  $o_1276->code = ValidationErrorCode::CSS_SYNTAX_EOF_IN_PRELUDE_OF_QUALIFIED_RULE;
  $o_1276->format = 'CSS syntax error in tag \'%1\' - end of stylesheet encountered in prelude of a qualified rule.';
  $o_0->error_formats[] = $o_1276;
  $o_1277 = new ErrorFormat();
  $o_1277->code = ValidationErrorCode::CSS_SYNTAX_INVALID_DECLARATION;
  $o_1277->format = 'CSS syntax error in tag \'%1\' - invalid declaration.';
  $o_0->error_formats[] = $o_1277;
  $o_1278 = new ErrorFormat();
  $o_1278->code = ValidationErrorCode::CSS_SYNTAX_INCOMPLETE_DECLARATION;
  $o_1278->format = 'CSS syntax error in tag \'%1\' - incomplete declaration.';
  $o_0->error_formats[] = $o_1278;
  $o_1279 = new ErrorFormat();
  $o_1279->code = ValidationErrorCode::CSS_SYNTAX_ERROR_IN_PSEUDO_SELECTOR;
  $o_1279->format = 'CSS syntax error in tag \'%1\' - invalid pseudo selector.';
  $o_0->error_formats[] = $o_1279;
  $o_1280 = new ErrorFormat();
  $o_1280->code = ValidationErrorCode::CSS_SYNTAX_MISSING_SELECTOR;
  $o_1280->format = 'CSS syntax error in tag \'%1\' - missing selector.';
  $o_0->error_formats[] = $o_1280;
  $o_1281 = new ErrorFormat();
  $o_1281->code = ValidationErrorCode::CSS_SYNTAX_NOT_A_SELECTOR_START;
  $o_1281->format = 'CSS syntax error in tag \'%1\' - not a selector start.';
  $o_0->error_formats[] = $o_1281;
  $o_1282 = new ErrorFormat();
  $o_1282->code = ValidationErrorCode::CSS_SYNTAX_UNPARSED_INPUT_REMAINS_IN_SELECTOR;
  $o_1282->format = 'CSS syntax error in tag \'%1\' - unparsed input remains in selector.';
  $o_0->error_formats[] = $o_1282;
  $o_1283 = new ErrorFormat();
  $o_1283->code = ValidationErrorCode::CSS_SYNTAX_MISSING_URL;
  $o_1283->format = 'CSS syntax error in tag \'%1\' - missing url.';
  $o_0->error_formats[] = $o_1283;
  $o_1284 = new ErrorFormat();
  $o_1284->code = ValidationErrorCode::CSS_SYNTAX_INVALID_URL;
  $o_1284->format = 'CSS syntax error in tag \'%1\' - invalid url \'%2\'.';
  $o_0->error_formats[] = $o_1284;
  $o_1285 = new ErrorFormat();
  $o_1285->code = ValidationErrorCode::CSS_SYNTAX_INVALID_URL_PROTOCOL;
  $o_1285->format = 'CSS syntax error in tag \'%1\' - invalid url protocol \'%2:\'.';
  $o_0->error_formats[] = $o_1285;
  $o_1286 = new ErrorFormat();
  $o_1286->code = ValidationErrorCode::CSS_SYNTAX_DISALLOWED_RELATIVE_URL;
  $o_1286->format = 'CSS syntax error in tag \'%1\' - disallowed relative url \'%2\'.';
  $o_0->error_formats[] = $o_1286;
  $o_1287 = new ErrorFormat();
  $o_1287->code = ValidationErrorCode::CSS_SYNTAX_INVALID_ATTR_SELECTOR;
  $o_1287->format = 'CSS syntax error in tag \'%1\' - invalid attribute selector.';
  $o_0->error_formats[] = $o_1287;
  return $o_0;
  }
}

